/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public class TrueDagFalseNegativesArrows
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "DFNA";
    }

    @Override
    public String getDescription() {
        return "False Negatives for Arrows compared to true DAG";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int fn = 0;
        List<Node> nodes = trueGraph.getNodes();
        for (Node x : nodes) {
            for (Node y : nodes) {
                Edge e;
                if (x == y || trueGraph.paths().isAncestorOf(x, y) || (e = estGraph.getEdge(x, y)) == null || e.getProximalEndpoint(x) == Endpoint.ARROW) continue;
                ++fn;
            }
        }
        return fn;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

