/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic.utils;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import java.util.HashSet;

public class AdjacencyConfusion {
    private int tp = 0;
    private int fp = 0;
    private int fn = 0;
    private final int tn;

    public AdjacencyConfusion(Graph truth, Graph est) {
        HashSet<Edge> allUnoriented = new HashSet<Edge>();
        for (Edge edge : truth.getEdges()) {
            allUnoriented.add(Edges.undirectedEdge(edge.getNode1(), edge.getNode2()));
        }
        for (Edge edge : est.getEdges()) {
            allUnoriented.add(Edges.undirectedEdge(edge.getNode1(), edge.getNode2()));
        }
        for (Edge edge : allUnoriented) {
            if (est.isAdjacentTo(edge.getNode1(), edge.getNode2()) && !truth.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                ++this.fp;
            }
            if (truth.isAdjacentTo(edge.getNode1(), edge.getNode2()) && !est.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                ++this.fn;
            }
            if (!truth.isAdjacentTo(edge.getNode1(), edge.getNode2()) || !est.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
            ++this.tp;
        }
        int allEdges = truth.getNumNodes() * (truth.getNumNodes() - 1) / 2;
        this.tn = allEdges - this.fn;
    }

    public int getTp() {
        return this.tp;
    }

    public int getFp() {
        return this.fp;
    }

    public int getFn() {
        return this.fn;
    }

    public int getTn() {
        return this.tn;
    }
}

