/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic.utils;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import java.util.HashSet;

public class BidirectedConfusion {
    private int tp = 0;
    private int fp = 0;
    private int fn = 0;
    private final int tn;

    public BidirectedConfusion(Graph truth, Graph est) {
        HashSet<Edge> allBidirected = new HashSet<Edge>();
        for (Edge edge : truth.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            allBidirected.add(edge);
        }
        for (Edge edge : est.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            allBidirected.add(edge);
        }
        for (Edge edge : allBidirected) {
            if (est.containsEdge(edge) && !truth.containsEdge(edge)) {
                ++this.fp;
            }
            if (truth.containsEdge(edge) && !est.containsEdge(edge)) {
                ++this.fn;
            }
            if (!truth.containsEdge(edge) || !est.containsEdge(edge)) continue;
            ++this.tp;
        }
        int all = truth.getNumNodes() * (truth.getNumNodes() - 1) / 2;
        this.tn = all - this.fn;
    }

    public int getTp() {
        return this.tp;
    }

    public int getFp() {
        return this.fp;
    }

    public int getFn() {
        return this.fn;
    }

    public int getTn() {
        return this.tn;
    }
}

