/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic.utils;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import java.util.List;

public class TailConfusion {
    private int tailsTp;
    private int tailsFp;
    private int tailsFn;
    private int tailsTn;
    private int TCtp;
    private int TCfn;
    private int TCfp;

    public TailConfusion(Graph truth, Graph est) {
        List<Edge> TwoCycle2;
        List<Edge> TwoCycle1;
        Endpoint e2True;
        Endpoint e1True;
        Edge edge2;
        List<Edge> edges2;
        Endpoint e2Est;
        Endpoint e1Est;
        Edge edge1;
        List<Edge> edges1;
        Graph est1 = est;
        this.tailsTp = 0;
        this.tailsFp = 0;
        this.tailsFn = 0;
        this.TCtp = 0;
        this.TCfn = 0;
        this.TCfp = 0;
        est1 = GraphUtils.replaceNodes(est, truth.getNodes());
        for (Edge edge : truth.getEdges()) {
            edges1 = est1.getEdges(edge.getNode1(), edge.getNode2());
            edge1 = edges1.size() == 1 ? edges1.get(0) : est1.getDirectedEdge(edge.getNode1(), edge.getNode2());
            e1Est = null;
            e2Est = null;
            if (edge1 != null) {
                e1Est = edge1.getProximalEndpoint(edge.getNode1());
                e2Est = edge1.getProximalEndpoint(edge.getNode2());
            }
            edge2 = (edges2 = truth.getEdges(edge.getNode1(), edge.getNode2())).size() == 1 ? edges2.get(0) : truth.getDirectedEdge(edge.getNode1(), edge.getNode2());
            e1True = null;
            e2True = null;
            if (edge2 != null) {
                e1True = edge2.getProximalEndpoint(edge.getNode1());
                e2True = edge2.getProximalEndpoint(edge.getNode2());
            }
            if (e1True == Endpoint.TAIL && e1Est != Endpoint.TAIL) {
                ++this.tailsFn;
            }
            if (e2True == Endpoint.TAIL && e2Est != Endpoint.TAIL) {
                ++this.tailsFn;
            }
            if (e1True == Endpoint.TAIL && e1Est == Endpoint.TAIL) {
                ++this.tailsTp;
            }
            if (e2True == Endpoint.TAIL && e2Est == Endpoint.TAIL) {
                ++this.tailsTp;
            }
            if (e1True != Endpoint.TAIL && e1Est != Endpoint.TAIL) {
                ++this.tailsTn;
            }
            if (e2True == Endpoint.TAIL || e2Est == Endpoint.TAIL) continue;
            ++this.tailsTn;
        }
        for (Edge edge : est1.getEdges()) {
            edges1 = est1.getEdges(edge.getNode1(), edge.getNode2());
            edge1 = edges1.size() == 1 ? edges1.get(0) : est1.getDirectedEdge(edge.getNode1(), edge.getNode2());
            e1Est = null;
            e2Est = null;
            if (edge1 != null) {
                e1Est = edge1.getProximalEndpoint(edge.getNode1());
                e2Est = edge1.getProximalEndpoint(edge.getNode2());
            }
            edge2 = (edges2 = truth.getEdges(edge.getNode1(), edge.getNode2())).size() == 1 ? edges2.get(0) : truth.getDirectedEdge(edge.getNode1(), edge.getNode2());
            e1True = null;
            e2True = null;
            if (edge2 != null) {
                e1True = edge2.getProximalEndpoint(edge.getNode1());
                e2True = edge2.getProximalEndpoint(edge.getNode2());
            }
            if (e1Est == Endpoint.TAIL && e1True != Endpoint.TAIL) {
                ++this.tailsFp;
            }
            if (e2Est != Endpoint.TAIL || e2True == Endpoint.TAIL) continue;
            ++this.tailsFp;
        }
        for (Edge edge : truth.getEdges()) {
            TwoCycle1 = truth.getEdges(edge.getNode1(), edge.getNode2());
            TwoCycle2 = est1.getEdges(edge.getNode1(), edge.getNode2());
            if (TwoCycle1.size() == 2 && TwoCycle2.size() == 2) {
                ++this.TCtp;
            }
            if (TwoCycle1.size() != 2 || TwoCycle2.size() == 2) continue;
            ++this.TCfn;
        }
        for (Edge edge : est1.getEdges()) {
            TwoCycle1 = truth.getEdges(edge.getNode1(), edge.getNode2());
            TwoCycle2 = est1.getEdges(edge.getNode1(), edge.getNode2());
            if (TwoCycle1.size() == 2 || TwoCycle2.size() != 2) continue;
            ++this.TCfp;
        }
        this.TCtp /= 2;
        this.TCfn /= 2;
        this.TCfp /= 2;
    }

    public int getArrowsTp() {
        return this.tailsTp;
    }

    public int getArrowsFp() {
        return this.tailsFp;
    }

    public int getArrowsFn() {
        return this.tailsFn;
    }

    public int getArrowsTn() {
        return this.tailsTn;
    }

    public int getTwoCycleTp() {
        return this.TCtp;
    }

    public int getTwoCycleFp() {
        return this.TCfp;
    }

    public int getTwoCycleFn() {
        return this.TCfn;
    }
}

