/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.annotation;

import edu.cmu.tetrad.annotation.AnnotatedClass;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class AnnotatedClassUtils {
    private AnnotatedClassUtils() {
    }

    public static <T extends Annotation> List<AnnotatedClass<T>> getAnnotatedClasses(String packageName, Class<T> type) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set<Class<?>> classes = reflections.getTypesAnnotatedWith(type);
        return classes.stream().map(e -> new AnnotatedClass((Class)e, e.getAnnotation(type))).collect(Collectors.toList());
    }

    public static <T extends Annotation> List<AnnotatedClass<T>> filterByAnnotations(Class<? extends Annotation> annotation, List<AnnotatedClass<T>> annotatedClasses) {
        LinkedList list = new LinkedList();
        if (annotatedClasses != null && !annotatedClasses.isEmpty()) {
            annotatedClasses.stream().filter(e -> e.getClazz().isAnnotationPresent(annotation)).collect(Collectors.toCollection(() -> list));
        }
        return list;
    }
}

