/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.PM;
import edu.cmu.tetrad.util.RandomUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;

public final class BayesPm
implements PM,
VariableSource {
    static final long serialVersionUID = 23L;
    private final Graph dag;
    private final Map<Node, DiscreteVariable> nodesToVariables;

    public BayesPm(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("The graph must not be null.");
        }
        this.dag = new EdgeListGraph(graph);
        this.nodesToVariables = new HashMap<Node, DiscreteVariable>();
        boolean allDiscreteVars = true;
        for (Node node : graph.getNodes()) {
            if (node instanceof DiscreteVariable) continue;
            allDiscreteVars = false;
            break;
        }
        if (!allDiscreteVars) {
            this.initializeValues(2, 2);
        } else {
            for (Node node : this.dag.getNodes()) {
                this.nodesToVariables.put(node, (DiscreteVariable)node);
            }
        }
    }

    public BayesPm(Graph graph, BayesPm oldBayesPm) {
        this(graph, oldBayesPm, 2, 2);
    }

    public BayesPm(Graph graph, int lowerBound, int upperBound) {
        if (graph == null) {
            throw new NullPointerException("The graph must not be null.");
        }
        this.dag = new EdgeListGraph(graph);
        this.nodesToVariables = new HashMap<Node, DiscreteVariable>();
        this.initializeValues(lowerBound, upperBound);
    }

    public BayesPm(Graph graph, BayesPm oldBayesPm, int lowerBound, int upperBound) {
        if (graph == null) {
            throw new NullPointerException("The graph must not be null.");
        }
        if (oldBayesPm == null) {
            throw new NullPointerException("BayesPm must not be null.");
        }
        if (graph.getNumNodes() == 0) {
            throw new IllegalArgumentException("The graph must have at least one node in it.");
        }
        this.dag = new EdgeListGraph(graph);
        this.nodesToVariables = new HashMap<Node, DiscreteVariable>();
        this.copyAvailableInformationFromOldBayesPm(oldBayesPm, lowerBound, upperBound);
    }

    public BayesPm(BayesPm bayesPm) {
        this.dag = bayesPm.dag;
        this.nodesToVariables = new HashMap<Node, DiscreteVariable>();
        for (Node node : bayesPm.nodesToVariables.keySet()) {
            DiscreteVariable variable = bayesPm.nodesToVariables.get(node);
            DiscreteVariable newVariable = new DiscreteVariable(variable);
            newVariable.setNodeType(node.getNodeType());
            this.nodesToVariables.put(node, newVariable);
        }
    }

    public static BayesPm serializableInstance() {
        return new BayesPm(Dag.serializableInstance());
    }

    public Graph getDag() {
        return this.dag;
    }

    public static List<String> getParameterNames() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("minCategories");
        parameters.add("maxCategories");
        return parameters;
    }

    public int getNumCategories(Node node) {
        DiscreteVariable variable = this.nodesToVariables.get(node);
        if (variable == null) {
            return 0;
        }
        return variable.getNumCategories();
    }

    public String getCategory(Node node, int index) {
        DiscreteVariable variable = this.nodesToVariables.get(node);
        if (variable != null) {
            return variable.getCategory(index);
        }
        for (DiscreteVariable _node : this.nodesToVariables.values()) {
            if (_node == null || !_node.getName().equals(node.getName())) continue;
            return _node.getCategory(index);
        }
        throw new IllegalStateException();
    }

    public int getCategoryIndex(Node node, String category) {
        DiscreteVariable variable = this.nodesToVariables.get(node);
        return variable.getIndex(category);
    }

    public void setNumCategories(Node node, int numCategories) {
        int i;
        if (!this.nodesToVariables.containsKey(node)) {
            throw new IllegalArgumentException("Node not in BayesPm: " + node);
        }
        if (numCategories < 1) {
            throw new IllegalArgumentException("Number of categories must be >= 1: " + numCategories);
        }
        DiscreteVariable variable = this.nodesToVariables.get(node);
        List<String> oldCategories = variable.getCategories();
        LinkedList<String> newCategories = new LinkedList<String>();
        int min = FastMath.min(numCategories, oldCategories.size());
        for (i = 0; i < min; ++i) {
            newCategories.add(oldCategories.get(i));
        }
        for (i = min; i < numCategories; ++i) {
            String proposedName = DataUtils.defaultCategory(i);
            if (newCategories.contains(proposedName)) {
                throw new IllegalArgumentException("Default name already in list of categories: " + proposedName);
            }
            newCategories.add(proposedName);
        }
        this.mapNodeToVariable(node, newCategories);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BayesPm)) {
            return false;
        }
        BayesPm bayesPm = (BayesPm)o;
        return bayesPm.dag.equals(this.dag) && bayesPm.nodesToVariables.equals(this.nodesToVariables);
    }

    public void setCategories(Node node, List<String> categories) {
        this.mapNodeToVariable(node, categories);
    }

    @Override
    public List<Node> getVariables() {
        LinkedList<Node> variables = new LinkedList<Node>();
        for (Node node : this.nodesToVariables.keySet()) {
            variables.add(this.nodesToVariables.get(node));
        }
        return variables;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> names = new ArrayList<String>();
        for (Node variable : variables) {
            DiscreteVariable discreteVariable = (DiscreteVariable)variable;
            names.add(discreteVariable.getName());
        }
        return names;
    }

    public Node getVariable(Node node) {
        return this.nodesToVariables.get(node);
    }

    public List<Node> getMeasuredNodes() {
        ArrayList<Node> measuredNodes = new ArrayList<Node>();
        for (Node variable : this.getVariables()) {
            if (variable.getNodeType() != NodeType.MEASURED) continue;
            measuredNodes.add(variable);
        }
        return measuredNodes;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Node node1 : this.nodesToVariables.keySet()) {
            buf.append("\n");
            buf.append(node1);
            buf.append(": ");
            DiscreteVariable variable = this.nodesToVariables.get(node1);
            for (int j = 0; j < variable.getNumCategories(); ++j) {
                buf.append(variable.getCategory(j));
                if (j >= variable.getNumCategories() - 1) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public Node getNode(String nodeName) {
        return this.dag.getNode(nodeName);
    }

    public Node getNode(int index) {
        return this.getVariables().get(index);
    }

    public int getNodeIndex() {
        return -1;
    }

    public int getNumNodes() {
        return this.dag.getNumNodes();
    }

    private void copyAvailableInformationFromOldBayesPm(BayesPm oldbayesPm, int lowerBound, int upperBound) {
        Graph newGraph = this.getDag();
        Graph oldGraph = oldbayesPm.getDag();
        for (Node node1 : newGraph.getNodes()) {
            if (oldGraph.containsNode(node1)) {
                this.copyOldValues(oldbayesPm, node1, node1, lowerBound, upperBound);
                continue;
            }
            this.setNewValues(node1, lowerBound, upperBound);
        }
        for (Node node2 : newGraph.getNodes()) {
            if (oldGraph.containsNode(node2)) {
                Node _node2 = this.dag.getNode(node2.getName());
                DiscreteVariable oldNode2 = oldbayesPm.nodesToVariables.get(_node2);
                oldNode2.setNodeType(node2.getNodeType());
                this.nodesToVariables.put(_node2, oldNode2);
                continue;
            }
            this.setNewValues(node2, lowerBound, upperBound);
        }
    }

    private void copyOldValues(BayesPm oldBayesPm, Node oldNode, Node node, int lowerBound, int upperBound) {
        int i;
        int numVals;
        ArrayList<String> values = new ArrayList<String>();
        LinkedList<String> oldNames = new LinkedList<String>();
        List<Node> oldNodes = oldBayesPm.getDag().getNodes();
        for (Node oldNode1 : oldNodes) {
            oldNames.add(oldNode1.getName());
        }
        if (oldNames.contains(node.getName())) {
            Node oldNode2 = oldBayesPm.getDag().getNode(node.getName());
            numVals = oldBayesPm.getNumCategories(oldNode2);
        } else {
            numVals = BayesPm.pickNumVals(lowerBound, upperBound);
        }
        int min = FastMath.min(oldBayesPm.getNumCategories(oldNode), numVals);
        for (i = 0; i < min; ++i) {
            values.add(oldBayesPm.getCategory(oldNode, i));
        }
        for (i = min; i < numVals; ++i) {
            String proposedName = DataUtils.defaultCategory(i);
            if (values.contains(proposedName)) {
                throw new IllegalArgumentException("Default name already in list of values: " + proposedName);
            }
            values.add(proposedName);
        }
        this.mapNodeToVariable(node, values);
    }

    private void setNewValues(Node node, int lowerBound, int upperBound) {
        if (node == null) {
            throw new NullPointerException("Node must not be null.");
        }
        ArrayList<String> valueList = new ArrayList<String>();
        for (int i = 0; i < BayesPm.pickNumVals(lowerBound, upperBound); ++i) {
            valueList.add(DataUtils.defaultCategory(i));
        }
        this.mapNodeToVariable(node, valueList);
    }

    private void mapNodeToVariable(Node node, List<String> categories) {
        if (categories.size() != new HashSet<String>(categories).size()) {
            throw new IllegalArgumentException("Duplicate variable names.");
        }
        DiscreteVariable variable = new DiscreteVariable(node.getName(), categories);
        variable.setNodeType(node.getNodeType());
        this.nodesToVariables.put(node, variable);
    }

    private void initializeValues(int lowerBound, int upperBound) {
        for (Node node : this.dag.getNodes()) {
            this.setNewValues(node, lowerBound, upperBound);
        }
    }

    private static int pickNumVals(int lowerBound, int upperBound) {
        if (lowerBound < 2) {
            throw new IllegalArgumentException("Lower bound must be >= 2: " + lowerBound);
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException("Upper bound for number of categories must be >= lower bound.");
        }
        int difference = upperBound - lowerBound;
        RandomUtil randomUtil = RandomUtil.getInstance();
        return randomUtil.nextInt(difference + 1) + lowerBound;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dag == null) {
            throw new NullPointerException();
        }
        if (this.nodesToVariables == null) {
            throw new NullPointerException();
        }
    }
}

