/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.Manipulation;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public final class Evidence
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private final Proposition proposition;
    private Manipulation manipulation;

    private Evidence(VariableSource variableSource) {
        if (variableSource == null) {
            throw new NullPointerException();
        }
        this.proposition = Proposition.tautology(variableSource);
        this.manipulation = new Manipulation(variableSource);
    }

    public Evidence(Evidence evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        this.proposition = new Proposition(evidence.getVariableSource(), evidence.getProposition());
        this.manipulation = new Manipulation(evidence.manipulation);
    }

    public Evidence(Proposition proposition) {
        if (proposition == null) {
            throw new NullPointerException();
        }
        this.proposition = new Proposition(proposition);
    }

    public Evidence(Evidence evidence, VariableSource variableSource) {
        if (variableSource == null) {
            throw new NullPointerException();
        }
        if (evidence == null) {
            throw new NullPointerException();
        }
        this.proposition = new Proposition(variableSource, evidence.getProposition());
        this.manipulation = new Manipulation(evidence.manipulation);
    }

    public static Evidence tautology(VariableSource variableSource) {
        return new Evidence(variableSource);
    }

    public static Evidence serializableInstance() {
        return new Evidence(MlBayesIm.serializableInstance());
    }

    public VariableSource getVariableSource() {
        return this.proposition.getVariableSource();
    }

    public int getNodeIndex(String nodeName) {
        return this.proposition.getNodeIndex(nodeName);
    }

    public int getCategoryIndex(String nodeName, String category) {
        return this.proposition.getCategoryIndex(nodeName, category);
    }

    public int getNumNodes() {
        return this.proposition.getVariableSource().getVariables().size();
    }

    public Node getNode(int nodeIndex) {
        return this.proposition.getVariableSource().getVariables().get(nodeIndex);
    }

    public DiscreteVariable getVariable(String nodeName) {
        int index = this.proposition.getVariableSource().getVariableNames().indexOf(nodeName);
        return (DiscreteVariable)this.proposition.getVariableSource().getVariables().get(index);
    }

    public int getNumCategories(int variable) {
        return this.proposition.getNumCategories(variable);
    }

    public Proposition getProposition() {
        return this.proposition;
    }

    public boolean isManipulated(int nodeIndex) {
        return this.manipulation.isManipulated(nodeIndex);
    }

    public void setManipulated(int nodeIndex, boolean manipulated) {
        this.manipulation.setManipulated(nodeIndex, manipulated);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nEvidence:");
        buf.append(this.getProposition());
        buf.append("\n");
        for (int i = 0; i < this.getNumNodes(); ++i) {
            buf.append(this.isManipulated(i) ? "(Man)" : "     ");
            buf.append("\t");
        }
        return buf.toString();
    }

    public boolean hasNoEvidence(int variable) {
        for (int i = 0; i < this.proposition.getNumCategories(variable); ++i) {
            if (this.proposition.isAllowed(variable, i)) continue;
            return false;
        }
        return true;
    }

    public List<Node> getVariablesInEvidence() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < this.getNumNodes(); ++i) {
            if (this.proposition.getSingleCategory(i) == -1) continue;
            nodes.add(this.getNode(i));
        }
        return nodes;
    }

    public String getCategory(Node node, int j) {
        DiscreteVariable variable = (DiscreteVariable)node;
        return variable.getCategory(j);
    }

    public boolean isIncompatibleWith(VariableSource variableSource) {
        List<Node> variables2;
        List<Node> variables1 = this.getVariableSource().getVariables();
        return !variables1.equals(variables2 = variableSource.getVariables());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Evidence)) {
            return false;
        }
        Evidence evidence = (Evidence)o;
        return this.proposition.equals(evidence.proposition) && this.manipulation.equals(evidence.manipulation);
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode = 19 * hashCode + this.proposition.hashCode();
        hashCode = 19 * hashCode + this.manipulation.hashCode();
        return hashCode;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.proposition == null) {
            throw new NullPointerException();
        }
    }
}

