/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.graph.Node;
import java.util.LinkedList;
import java.util.List;

public final class ExtraCategoryInterpolator
implements DataFilter {
    @Override
    public DataSet filter(DataSet dataSet) {
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int j = 0; j < dataSet.getNumColumns(); ++j) {
            Node _var = dataSet.getVariable(j);
            if (!(_var instanceof DiscreteVariable)) {
                variables.add(_var);
                continue;
            }
            DiscreteVariable variable = (DiscreteVariable)_var;
            String oldName = variable.getName();
            List<String> oldCategories = variable.getCategories();
            LinkedList<String> newCategories = new LinkedList<String>(oldCategories);
            String newCategory = "Missing";
            int _j = 0;
            while (oldCategories.contains(newCategory)) {
                newCategory = "Missing" + ++_j;
            }
            newCategories.add(newCategory);
            String newName = oldName + "+";
            DiscreteVariable newVariable = new DiscreteVariable(newName, newCategories);
            variables.add(newVariable);
        }
        BoxDataSet newDataSet = new BoxDataSet(new DoubleDataBox(dataSet.getNumRows(), variables.size()), variables);
        for (int j = 0; j < dataSet.getNumColumns(); ++j) {
            Node _var = dataSet.getVariable(j);
            if (_var instanceof ContinuousVariable) {
                for (int i = 0; i < dataSet.getNumRows(); ++i) {
                    newDataSet.setDouble(i, j, dataSet.getDouble(i, j));
                }
                continue;
            }
            if (!(_var instanceof DiscreteVariable)) continue;
            DiscreteVariable variable = (DiscreteVariable)_var;
            int numCategories = variable.getNumCategories();
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                int value = dataSet.getInt(i, j);
                if (value == -99) {
                    newDataSet.setInt(i, j, numCategories);
                    continue;
                }
                newDataSet.setInt(i, j, value);
            }
        }
        return newDataSet;
    }
}

