/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GraphTools {
    private GraphTools() {
    }

    public static Map<Node, Node> getCliqueTree(Node[] ordering, Map<Node, Set<Node>> cliques, Map<Node, Set<Node>> separators) {
        HashMap<Node, Node> parentCliques = new HashMap<Node, Node>();
        Arrays.stream(ordering).forEach(v -> {
            if (cliques.containsKey(v) && separators.containsKey(v) && !((Set)separators.get(v)).isEmpty()) {
                for (Node w : ordering) {
                    if (v == w || !cliques.containsKey(w) || !((Set)cliques.get(w)).containsAll((Collection)separators.get(v))) continue;
                    parentCliques.put((Node)v, w);
                    break;
                }
            }
        });
        return parentCliques;
    }

    public static Map<Node, Set<Node>> getSeparators(Node[] ordering, Map<Node, Set<Node>> cliques) {
        HashMap<Node, Set<Node>> separators = new HashMap<Node, Set<Node>>();
        HashSet processedNodes = new HashSet();
        Arrays.stream(ordering).forEach(node -> {
            Set clique;
            if (cliques.containsKey(node) && !(clique = (Set)cliques.get(node)).isEmpty()) {
                HashSet separator = new HashSet(clique);
                separator.retainAll(processedNodes);
                separators.put((Node)node, separator);
                processedNodes.addAll(clique);
            }
        });
        return separators;
    }

    public static Map<Node, Set<Node>> getCliques(Node[] ordering, Graph graph) {
        HashMap<Node, Set<Node>> cliques = new HashMap<Node, Set<Node>>();
        for (int i = ordering.length - 1; i >= 0; --i) {
            Node v = ordering[i];
            HashSet<Node> clique = new HashSet<Node>();
            clique.add(v);
            for (int j = 0; j < i; ++j) {
                Node w = ordering[j];
                if (!graph.isAdjacentTo(v, w)) continue;
                clique.add(w);
            }
            cliques.put(v, clique);
        }
        cliques.forEach((k1, v1) -> cliques.forEach((k2, v2) -> {
            if (k1 != k2 && !v1.isEmpty() && !v2.isEmpty() && v1.containsAll((Collection<?>)v2)) {
                v2.clear();
            }
        }));
        while (cliques.values().remove(Collections.EMPTY_SET)) {
        }
        return cliques;
    }

    public static void fillIn(Graph graph, Node[] ordering) {
        int numOfNodes = ordering.length;
        for (int i = numOfNodes - 1; i >= 0; --i) {
            Node v = ordering[i];
            for (int j = 0; j < i; ++j) {
                Node w = ordering[j];
                if (!graph.isAdjacentTo(v, w)) continue;
                for (int k = j + 1; k < i; ++k) {
                    Node x = ordering[k];
                    if (!graph.isAdjacentTo(x, v)) continue;
                    graph.addUndirectedEdge(x, w);
                }
            }
        }
    }

    public static Node[] getMaximumCardinalityOrdering(Graph graph) {
        int numOfNodes = graph.getNumNodes();
        if (numOfNodes == 0) {
            return new Node[0];
        }
        Node[] ordering = new Node[numOfNodes];
        HashSet<Node> numbered = new HashSet<Node>(numOfNodes);
        for (int i = 0; i < numOfNodes; ++i) {
            Node maxCardinalityNode = null;
            int maxCardinality = -1;
            for (Node v : graph.getNodes()) {
                if (numbered.contains(v)) continue;
                int cardinality = (int)graph.getAdjacentNodes(v).stream().filter(numbered::contains).count();
                if (cardinality <= maxCardinality) continue;
                maxCardinality = cardinality;
                maxCardinalityNode = v;
            }
            ordering[i] = maxCardinalityNode;
            numbered.add(maxCardinalityNode);
        }
        return ordering;
    }

    public static Graph moralize(Graph graph) {
        EdgeListGraph moralGraph = new EdgeListGraph(graph.getNodes());
        graph.getEdges().forEach(e -> moralGraph.addUndirectedEdge(e.getNode1(), e.getNode2()));
        graph.getNodes().forEach(node -> {
            List<Node> parents = graph.getParents((Node)node);
            if (parents != null && !parents.isEmpty() && parents.size() > 1) {
                Node[] p = parents.toArray(new Node[0]);
                for (int i = 0; i < p.length; ++i) {
                    for (int j = i + 1; j < p.length; ++j) {
                        Node node1 = p[i];
                        Node node2 = p[j];
                        if (moralGraph.isAdjacentTo(node1, node2)) continue;
                        moralGraph.addUndirectedEdge(node1, node2);
                    }
                }
            }
        });
        return moralGraph;
    }
}

