/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.ManipulatingBayesUpdater;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.MlBayesImObs;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.bayes.QList;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Paths;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class Identifiability
implements ManipulatingBayesUpdater {
    static final long serialVersionUID = 23L;
    private final BayesIm bayesIm;
    private Evidence evidence;
    private BayesIm manipulatedBayesIm;
    private final boolean debug = false;

    public Identifiability(BayesIm bayesIm) {
        this(bayesIm, Evidence.tautology(bayesIm));
    }

    public static Identifiability serializableInstance() {
        return new Identifiability(MlBayesIm.serializableInstance());
    }

    public Identifiability(BayesIm bayesIm, Evidence evidence) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        this.bayesIm = bayesIm;
        this.setEvidence(evidence);
        Objects.requireNonNull(this);
    }

    @Override
    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    @Override
    public BayesIm getManipulatedBayesIm() {
        return this.manipulatedBayesIm;
    }

    @Override
    public Graph getManipulatedGraph() {
        return this.getManipulatedBayesIm().getDag();
    }

    @Override
    public BayesIm getUpdatedBayesIm() {
        return null;
    }

    @Override
    public Evidence getEvidence() {
        return new Evidence(this.evidence);
    }

    @Override
    public void setEvidence(Evidence evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        if (evidence.isIncompatibleWith(this.bayesIm)) {
            throw new IllegalArgumentException("The variable list for the given bayesIm must be compatible with the variable list for this evidence.");
        }
        this.evidence = evidence;
        Graph graph = this.bayesIm.getBayesPm().getDag();
        Dag manipulatedGraph = this.createManipulatedGraph(graph);
        BayesPm manipulatedPm = this.createUpdatedBayesPm(manipulatedGraph);
        this.manipulatedBayesIm = this.createdUpdatedBayesIm(manipulatedPm);
    }

    @Override
    public boolean isJointMarginalSupported() {
        return true;
    }

    @Override
    public double getJointMarginal(int[] sVariables, int[] sValues) {
        int i;
        int i2;
        if (sVariables.length != sValues.length) {
            throw new IllegalArgumentException("Values must match variables.");
        }
        ArrayList<Node> sNodes = new ArrayList<Node>();
        for (int sVariable : sVariables) {
            sNodes.add(this.bayesIm.getNode(sVariable));
        }
        Objects.requireNonNull(this);
        List<Node> tNodesTmp = this.evidence.getVariablesInEvidence();
        if (tNodesTmp.size() == 0) {
            Proposition prop = Proposition.tautology(this.bayesIm);
            for (int i3 = 0; i3 < sVariables.length; ++i3) {
                prop.setCategory(sVariables[i3], sValues[i3]);
            }
            Proposition propObs = new Proposition(((MlBayesImObs)this.bayesIm).getBayesImObs(), prop);
            return ((MlBayesImObs)this.bayesIm).getJPD().getProb(propObs);
        }
        ArrayList<Node> tNodes = new ArrayList<Node>();
        for (Node node1 : tNodesTmp) {
            tNodes.add(this.bayesIm.getNode(node1.getName()));
        }
        Objects.requireNonNull(this);
        int nNodes = this.bayesIm.getNumNodes();
        int[] fixedVarValues = new int[nNodes];
        for (i2 = 0; i2 < nNodes; ++i2) {
            fixedVarValues[i2] = -1;
        }
        for (i2 = 0; i2 < sVariables.length; ++i2) {
            fixedVarValues[sVariables[i2]] = sValues[i2];
        }
        for (i2 = 0; i2 < this.evidence.getNumNodes(); ++i2) {
            int tNodeValue = this.evidence.getProposition().getSingleCategory(i2);
            if (tNodeValue == -1) continue;
            Node tNode = this.evidence.getNode(i2);
            String tNodeStr = this.evidence.getNode(i2).getName();
            Node tNodeInBayesIm = this.bayesIm.getNode(tNodeStr);
            int tIndexInBayesIm = this.bayesIm.getNodeIndex(tNodeInBayesIm);
            String tCategoryStr = this.evidence.getCategory(tNode, tNodeValue);
            int tValueInBayesIm = this.bayesIm.getBayesPm().getCategoryIndex(tNodeInBayesIm, tCategoryStr);
            int oldValue = fixedVarValues[tIndexInBayesIm];
            if (oldValue != -1) {
                if (oldValue == tValueInBayesIm) {
                    sNodes.remove(tNodeInBayesIm);
                    Objects.requireNonNull(this);
                    continue;
                }
                return 0.0;
            }
            fixedVarValues[tIndexInBayesIm] = tValueInBayesIm;
        }
        Objects.requireNonNull(this);
        if (sNodes.size() == 0) {
            return 1.0;
        }
        int[] cComponents = this.getCComponents(this.bayesIm);
        int nCComponents = this.nCComponents(cComponents);
        LinkedList<List<Node>> cComponentNodes = new LinkedList<List<Node>>();
        for (int i4 = 0; i4 < nCComponents; ++i4) {
            cComponentNodes.add(this.getCComponentNodes(this.bayesIm, cComponents, i4));
        }
        Objects.requireNonNull(this);
        int[] probTermV = new int[nNodes];
        for (int i5 = 0; i5 < nNodes; ++i5) {
            if (this.bayesIm.getNode(i5).getNodeType() != NodeType.MEASURED) continue;
            probTermV[i5] = 1;
        }
        Objects.requireNonNull(this);
        QList[] cFactors = new QList[nCComponents];
        for (int i6 = 0; i6 < nCComponents; ++i6) {
            QList qV = new QList(nNodes, probTermV);
            Objects.requireNonNull(this);
            cFactors[i6] = this.qDecomposition(this.bayesIm, this.bayesIm.getDag().getNodes(), (List)cComponentNodes.get(i6), qV);
            Objects.requireNonNull(this);
        }
        Dag dag = new Dag(this.bayesIm.getDag());
        Objects.requireNonNull(this);
        dag.removeNodes(tNodes);
        Objects.requireNonNull(this);
        List<Node> dNodes = dag.paths().getAncestors(sNodes);
        Dag gD = new Dag(this.bayesIm.getDag().subgraph(dNodes));
        BayesPm bayesPmD = new BayesPm(gD, this.bayesIm.getBayesPm());
        MlBayesIm bayesImD = new MlBayesIm(bayesPmD, this.bayesIm, 1);
        Objects.requireNonNull(this);
        int[] cComponentsD = this.getCComponents(bayesImD);
        int nCComponentsD = this.nCComponents(cComponentsD);
        QList[] qD = new QList[nCComponentsD];
        for (int i7 = 0; i7 < nCComponentsD; ++i7) {
            List<Node> cComponentNodesDi = this.getCComponentNodes(bayesImD, cComponentsD, i7);
            boolean flag = false;
            for (int j = 0; j < nCComponents && !flag; ++j) {
                List cComponentNodesSj = (List)cComponentNodes.get(j);
                if (!cComponentNodesSj.containsAll(cComponentNodesDi)) continue;
                Objects.requireNonNull(this);
                flag = true;
                qD[i7] = this.identify(cComponentNodesDi, cComponentNodesSj, cFactors[j]);
                if (qD[i7] == null) {
                    Objects.requireNonNull(this);
                    return -1.0;
                }
                Objects.requireNonNull(this);
            }
            if (flag) continue;
            throw new RuntimeException("getJointMarginal: Sj not found");
        }
        QList qDProducts = new QList(nNodes);
        int[] sumOverVariables = new int[nNodes];
        for (i = 0; i < nNodes; ++i) {
            sumOverVariables[i] = 0;
        }
        for (i = 0; i < nCComponentsD; ++i) {
            qDProducts.add(qD[i], sumOverVariables, true);
        }
        QList qPTS = new QList(nNodes);
        qPTS.add(qDProducts, this.sumList(nNodes, dNodes, sNodes), true);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        return qPTS.computeValue(this.bayesIm, fixedVarValues);
    }

    @Override
    public double getMarginal(int variable, int value) {
        int[] sVariables = new int[]{variable};
        int[] sValues = new int[]{value};
        return this.getJointMarginal(sVariables, sValues);
    }

    @Override
    public double[] calculatePriorMarginals(int nodeIndex) {
        Evidence evidence = this.getEvidence();
        this.setEvidence(Evidence.tautology(evidence.getVariableSource()));
        double[] marginals = new double[this.getBayesIm().getNumColumns(nodeIndex)];
        for (int i = 0; i < this.getBayesIm().getNumColumns(nodeIndex); ++i) {
            marginals[i] = this.getMarginal(nodeIndex, i);
        }
        this.setEvidence(evidence);
        return marginals;
    }

    @Override
    public double[] calculateUpdatedMarginals(int nodeIndex) {
        double[] marginals = new double[this.getBayesIm().getNumColumns(nodeIndex)];
        for (int i = 0; i < this.getBayesIm().getNumColumns(nodeIndex); ++i) {
            marginals[i] = this.getMarginal(nodeIndex, i);
        }
        return marginals;
    }

    public String toString() {
        return "Identifiability";
    }

    private int[] getCComponents(BayesIm bayesIm) {
        int nNodes = bayesIm.getNumNodes();
        int[] cComponents1 = new int[nNodes];
        int[] cComponents2 = new int[nNodes];
        for (int i = 0; i < nNodes; ++i) {
            cComponents1[i] = i;
        }
        for (int nodeIndex = 0; nodeIndex < nNodes; ++nodeIndex) {
            int cComponentIndexNew = cComponents1[nodeIndex];
            int nParents = bayesIm.getNumParents(nodeIndex);
            for (int i = 0; i < nParents; ++i) {
                int cComponentIndexOld;
                int parentIndex = bayesIm.getParent(nodeIndex, i);
                if (bayesIm.getNode(parentIndex).getNodeType() != NodeType.LATENT || (cComponentIndexOld = cComponents1[parentIndex]) == cComponentIndexNew) continue;
                for (int j = 0; j < nNodes; ++j) {
                    if (cComponents1[j] != cComponentIndexOld) continue;
                    cComponents1[j] = cComponentIndexNew;
                }
            }
        }
        int cComponentIndexNew = 0;
        for (int i = 0; i < nNodes; ++i) {
            boolean hasValue = false;
            int cComponentIndexOld = cComponents1[i];
            for (int j = 0; j < i && !hasValue; ++j) {
                if (cComponents1[j] != cComponentIndexOld) continue;
                cComponents2[i] = cComponents2[j];
                hasValue = true;
            }
            if (hasValue) continue;
            cComponents2[i] = cComponentIndexNew++;
        }
        return cComponents2;
    }

    private int nCComponents(int[] cComponents) {
        int currentMax = -1;
        for (int cComponent : cComponents) {
            if (cComponent <= currentMax) continue;
            currentMax = cComponent;
        }
        return currentMax + 1;
    }

    private List<Node> getCComponentNodes(BayesIm bayesIm, int[] cComponents, int index) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (int i = 0; i < cComponents.length; ++i) {
            if (cComponents[i] != index) continue;
            nodeList.add(bayesIm.getNode(i));
        }
        return nodeList;
    }

    private void printCComponents(int[] cComponents) {
        System.out.println("----- printCComponents: total " + this.nCComponents(cComponents) + " -----");
        for (int i = 0; i < cComponents.length; ++i) {
            System.out.println(i + ": " + cComponents[i]);
        }
    }

    private QList qDecomposition(BayesIm graphWhole, List<Node> h, List<Node> hj, QList qH) {
        Dag graphH = new Dag(graphWhole.getDag().subgraph(h));
        Paths paths = graphH.paths();
        List<Node> initialOrder = graphH.getNodes();
        List<Node> tierOrdering = paths.validOrder(initialOrder, true);
        int tierSize = tierOrdering.size();
        int[] tiers = new int[tierSize];
        for (int i = 0; i < tierSize; ++i) {
            tiers[i] = graphWhole.getNodeIndex(tierOrdering.get(i));
        }
        Objects.requireNonNull(this);
        int nNodes = graphWhole.getNumNodes();
        QList qHj = new QList(nNodes);
        for (Node nodeHj : hj) {
            int i;
            int nodeHjTierIndex;
            int nodeHjIndex = graphWhole.getNodeIndex(nodeHj);
            if (graphWhole.getNode(nodeHjIndex).getNodeType() != NodeType.MEASURED) continue;
            for (nodeHjTierIndex = 0; nodeHjTierIndex < tierSize && tiers[nodeHjTierIndex] != nodeHjIndex; ++nodeHjTierIndex) {
            }
            if (nodeHjTierIndex == tierSize) {
                throw new RuntimeException("qDecomposition: index out of bound");
            }
            int[] sumOverVariables = new int[nNodes];
            for (i = 0; i < nNodes; ++i) {
                sumOverVariables[i] = 0;
            }
            for (i = nodeHjTierIndex + 1; i < tierSize; ++i) {
                if (graphWhole.getNode(tiers[i]).getNodeType() != NodeType.MEASURED) continue;
                sumOverVariables[tiers[i]] = 1;
            }
            qHj.add(qH, sumOverVariables, true);
            Objects.requireNonNull(this);
            sumOverVariables[tiers[nodeHjTierIndex]] = 1;
            qHj.add(qH, sumOverVariables, false);
            Objects.requireNonNull(this);
        }
        return qHj;
    }

    private int[] sumList(int nNodes, List<Node> bigSet, List<Node> smallSet) {
        int[] sumOverVariables = new int[nNodes];
        for (int i = 0; i < nNodes; ++i) {
            sumOverVariables[i] = 0;
        }
        for (Node node1 : bigSet) {
            if (smallSet.contains(node1) || node1.getNodeType() != NodeType.MEASURED) continue;
            sumOverVariables[this.bayesIm.getNodeIndex((Node)node1)] = 1;
        }
        return sumOverVariables;
    }

    private QList identify(List<Node> nodesC, List<Node> nodesT, QList qT) {
        Dag graphT = new Dag(this.bayesIm.getDag().subgraph(nodesT));
        List<Node> nodesA = graphT.paths().getAncestors(nodesC);
        int nNodes = this.bayesIm.getNumNodes();
        QList qC = new QList(nNodes);
        Objects.requireNonNull(this);
        if (nodesC.containsAll(nodesA)) {
            qC.add(qT, this.sumList(nNodes, nodesT, nodesC), true);
            Objects.requireNonNull(this);
            return qC;
        }
        if (nodesA.containsAll(nodesT)) {
            Objects.requireNonNull(this);
            return null;
        }
        Dag graphA = new Dag(this.bayesIm.getDag().subgraph(nodesA));
        BayesPm bayesPmA = new BayesPm(graphA, this.bayesIm.getBayesPm());
        MlBayesIm bayesImA = new MlBayesIm(bayesPmA, this.bayesIm, 1);
        int[] cComponentsA = this.getCComponents(bayesImA);
        int nCComponentsA = this.nCComponents(cComponentsA);
        QList qA = new QList(nNodes);
        qA.add(qT, this.sumList(nNodes, nodesT, nodesA), true);
        for (int i = this.debug; i < nCComponentsA; ++i) {
            List<Node> cComponentNodesT2 = this.getCComponentNodes(bayesImA, cComponentsA, i);
            Objects.requireNonNull(this);
            if (!cComponentNodesT2.containsAll(nodesC)) continue;
            QList qT2 = this.qDecomposition(this.bayesIm, nodesA, cComponentNodesT2, qA);
            return this.identify(nodesC, cComponentNodesT2, qT2);
        }
        throw new RuntimeException("identify: T2 not found");
    }

    private BayesIm createdUpdatedBayesIm(BayesPm updatedBayesPm) {
        return new MlBayesIm(updatedBayesPm, this.bayesIm, 1);
    }

    private BayesPm createUpdatedBayesPm(Dag updatedGraph) {
        return new BayesPm(updatedGraph, this.bayesIm.getBayesPm());
    }

    private Dag createManipulatedGraph(Graph graph) {
        Dag updatedGraph = new Dag(graph);
        for (int i = 0; i < this.evidence.getNumNodes(); ++i) {
            if (!this.evidence.isManipulated(i)) continue;
            Node node = updatedGraph.getNode(this.evidence.getNode(i).getName());
            List<Node> parents = updatedGraph.getParents(node);
            for (Node parent1 : parents) {
                updatedGraph.removeEdge(node, parent1);
            }
        }
        return updatedGraph;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
        if (this.evidence == null) {
            throw new NullPointerException();
        }
    }
}

