/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.DiscreteProbs;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.Arrays;
import java.util.List;

public final class IntAveDataSetProbs
implements DiscreteProbs {
    private final DataSet dataSet;
    private final int[] dims;
    private final int numRows;

    public IntAveDataSetProbs(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.dims = new int[dataSet.getNumColumns()];
        for (int i = 0; i < this.dims.length; ++i) {
            DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(i);
            this.dims[i] = variable.getNumCategories();
        }
        this.numRows = dataSet.getNumRows();
    }

    @Override
    public double getCellProb(int[] variableValues) {
        int[] point = new int[this.dims.length];
        int count = 0;
        block0: for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims[i]; ++j) {
                point[j] = this.dataSet.getInt(i, j);
                if (point[j] == -99) continue block0;
            }
            if (!Arrays.equals(point, variableValues)) continue;
            ++count;
        }
        return (double)count / (double)this.numRows;
    }

    @Override
    public double getProb(Proposition assertion) {
        int[] point = new int[this.dims.length];
        int count = 0;
        block0: for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = this.dataSet.getInt(i, j);
                if (point[j] == -99) continue block0;
            }
            if (!assertion.isPermissibleCombination(point)) continue;
            ++count;
        }
        return (double)count / (double)this.numRows;
    }

    @Override
    public double getConditionalProb(Proposition assertion, Proposition condition) {
        List<Node> dataVars;
        if (assertion.getVariableSource() != condition.getVariableSource()) {
            throw new IllegalArgumentException("Assertion and condition must be for the same Bayes IM.");
        }
        List<Node> assertionVars = assertion.getVariableSource().getVariables();
        if (!assertionVars.equals(dataVars = this.dataSet.getVariables())) {
            throw new IllegalArgumentException("Assertion variable and data variables are either different or in a different order: \n\tAssertion vars: " + assertionVars + "\n\tData vars: " + dataVars);
        }
        int[] point = new int[this.dims.length];
        int count1 = 0;
        int count2 = 0;
        block0: for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = this.dataSet.getInt(i, j);
                if (point[j] == -99) continue block0;
            }
            if (!condition.isPermissibleCombination(point)) continue;
            ++count1;
            if (!assertion.isPermissibleCombination(point)) continue;
            ++count2;
        }
        double p = (double)count2 / (double)count1;
        if (!Double.isNaN(p)) {
            return p;
        }
        int numDefinedProbs = 0;
        double sumProbs = 0.0;
        for (int i = 0; i < this.dims.length; ++i) {
            if (!condition.isConditioned(i)) continue;
            Proposition condition2 = new Proposition(condition);
            condition.setVariable(i, true);
            count1 = 0;
            count2 = 0;
            block3: for (int i1 = 0; i1 < this.numRows; ++i1) {
                for (int j = 0; j < this.dims.length; ++j) {
                    point[j] = this.dataSet.getInt(i, j);
                    if (point[j] == -99) continue block3;
                }
                if (!condition2.isPermissibleCombination(point)) continue;
                ++count1;
                if (!assertion.isPermissibleCombination(point)) continue;
                ++count2;
            }
            p = (double)count2 / (double)count1;
            if (Double.isNaN(p)) continue;
            ++numDefinedProbs;
            sumProbs += p;
        }
        return sumProbs / (double)numDefinedProbs;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public List<Node> getVariables() {
        return null;
    }
}

