/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.JunctionTreeAlgorithm;
import edu.cmu.tetrad.bayes.ManipulatingBayesUpdater;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.bayes.UpdatedBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;

public class JunctionTreeUpdater
implements ManipulatingBayesUpdater {
    static final long serialVersionUID = 23L;
    private Evidence evidence;
    private BayesIm manipulatedBayesIm;
    private BayesIm updatedBayesIm;
    private JunctionTreeAlgorithm jta;
    private final BayesIm bayesIm;

    public JunctionTreeUpdater(BayesIm bayesIm) {
        this(bayesIm, Evidence.tautology(bayesIm));
    }

    public JunctionTreeUpdater(BayesIm bayesIm, Evidence evidence) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        this.bayesIm = bayesIm;
        this.setEvidence(evidence);
    }

    @Override
    public BayesIm getManipulatedBayesIm() {
        return this.manipulatedBayesIm;
    }

    @Override
    public Graph getManipulatedGraph() {
        return this.getManipulatedBayesIm().getDag();
    }

    @Override
    public Evidence getEvidence() {
        return new Evidence(this.evidence);
    }

    @Override
    public void setEvidence(Evidence evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        if (evidence.isIncompatibleWith(this.bayesIm)) {
            throw new IllegalArgumentException("The variable list for the given bayesIm must be compatible with the variable list for this evidence.");
        }
        this.evidence = evidence;
        Graph graph = this.bayesIm.getBayesPm().getDag();
        Dag manipulatedGraph = this.createManipulatedGraph(graph);
        BayesPm manipulatedPm = this.createUpdatedBayesPm(manipulatedGraph);
        this.manipulatedBayesIm = this.createdUpdatedBayesIm(manipulatedPm);
        Evidence evidence2 = new Evidence(evidence, this.manipulatedBayesIm);
        this.updatedBayesIm = new UpdatedBayesIm(this.manipulatedBayesIm, evidence2);
        this.jta = new JunctionTreeAlgorithm(this.updatedBayesIm);
    }

    @Override
    public BayesIm getUpdatedBayesIm() {
        if (this.updatedBayesIm == null) {
            this.updateAll();
        }
        return this.updatedBayesIm;
    }

    @Override
    public double getMarginal(int variable, int category) {
        Proposition assertion = Proposition.tautology(this.manipulatedBayesIm);
        Proposition condition = new Proposition(this.manipulatedBayesIm, this.evidence.getProposition());
        assertion.setCategory(variable, category);
        if (condition.existsCombination()) {
            return this.jta.getMarginalProbability(variable, category);
        }
        return Double.NaN;
    }

    @Override
    public boolean isJointMarginalSupported() {
        return true;
    }

    @Override
    public double getJointMarginal(int[] variables, int[] values) {
        if (variables.length != values.length) {
            throw new IllegalArgumentException("Values must match variables.");
        }
        Proposition assertion = Proposition.tautology(this.manipulatedBayesIm);
        Proposition condition = new Proposition(this.manipulatedBayesIm, this.evidence.getProposition());
        for (int i = 0; i < variables.length; ++i) {
            assertion.setCategory(variables[i], values[i]);
        }
        if (condition.existsCombination()) {
            double joint = 1.0;
            for (int i = 0; i < variables.length; ++i) {
                joint *= this.jta.getMarginalProbability(variables[i], values[i]);
            }
            return joint;
        }
        return Double.NaN;
    }

    @Override
    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    @Override
    public double[] calculatePriorMarginals(int nodeIndex) {
        Evidence evidence = this.getEvidence();
        this.setEvidence(Evidence.tautology(evidence.getVariableSource()));
        double[] marginals = new double[evidence.getNumCategories(nodeIndex)];
        for (int i = 0; i < this.getBayesIm().getNumColumns(nodeIndex); ++i) {
            marginals[i] = this.getMarginal(nodeIndex, i);
        }
        this.setEvidence(evidence);
        return marginals;
    }

    @Override
    public double[] calculateUpdatedMarginals(int nodeIndex) {
        double[] marginals = new double[this.evidence.getNumCategories(nodeIndex)];
        for (int i = 0; i < this.getBayesIm().getNumColumns(nodeIndex); ++i) {
            marginals[i] = this.getMarginal(nodeIndex, i);
        }
        return marginals;
    }

    public String toString() {
        return "Junction tree updater, evidence = " + this.evidence;
    }

    private void updateAll() {
        this.updatedBayesIm = new MlBayesIm(this.manipulatedBayesIm);
        int numNodes = this.manipulatedBayesIm.getNumNodes();
        Proposition assertion = Proposition.tautology(this.manipulatedBayesIm);
        Proposition condition = Proposition.tautology(this.manipulatedBayesIm);
        Evidence evidence2 = new Evidence(this.evidence, this.manipulatedBayesIm);
        for (int node = 0; node < numNodes; ++node) {
            int numRows = this.manipulatedBayesIm.getNumRows(node);
            int numCols = this.manipulatedBayesIm.getNumColumns(node);
            int[] parents = this.manipulatedBayesIm.getParents(node);
            for (int row = 0; row < numRows; ++row) {
                int[] parentValues = this.manipulatedBayesIm.getParentValues(node, row);
                for (int col = 0; col < numCols; ++col) {
                    assertion.setToTautology();
                    condition.setToTautology();
                    for (int i = 0; i < numNodes; ++i) {
                        for (int j = 0; j < evidence2.getNumCategories(i); ++j) {
                            if (evidence2.getProposition().isAllowed(i, j)) continue;
                            condition.removeCategory(i, j);
                        }
                    }
                    assertion.disallowComplement(node, col);
                    for (int k = 0; k < parents.length; ++k) {
                        condition.disallowComplement(parents[k], parentValues[k]);
                    }
                    if (condition.existsCombination()) {
                        double p = parents.length > 0 ? this.jta.getConditionalProbability(node, col, parents, parentValues) : this.jta.getMarginalProbability(node, col);
                        this.updatedBayesIm.setProbability(node, row, col, p);
                        continue;
                    }
                    this.updatedBayesIm.setProbability(node, row, col, Double.NaN);
                }
            }
        }
    }

    private BayesIm createdUpdatedBayesIm(BayesPm updatedBayesPm) {
        return new MlBayesIm(updatedBayesPm, this.bayesIm, 0);
    }

    private BayesPm createUpdatedBayesPm(Dag updatedGraph) {
        return new BayesPm(updatedGraph, this.bayesIm.getBayesPm());
    }

    private Dag createManipulatedGraph(Graph graph) {
        Dag updatedGraph = new Dag(graph);
        for (int i = 0; i < this.evidence.getNumNodes(); ++i) {
            if (!this.evidence.isManipulated(i)) continue;
            Node node = updatedGraph.getNode(this.evidence.getNode(i).getName());
            List<Node> parents = updatedGraph.getParents(node);
            Iterator<Node> iterator = parents.iterator();
            while (iterator.hasNext()) {
                Node parent1;
                Node parent = parent1 = iterator.next();
                updatedGraph.removeEdge(node, parent);
            }
        }
        return updatedGraph;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
        if (this.evidence == null) {
            throw new NullPointerException();
        }
    }
}

