/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BayesUtils;
import edu.cmu.tetrad.bayes.DataSetProbs;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public final class MlBayesEstimator {
    public BayesIm estimate(BayesPm bayesPm, DataSet dataSet) {
        if (bayesPm == null) {
            throw new NullPointerException();
        }
        if (dataSet == null) {
            throw new NullPointerException();
        }
        BayesUtils.ensureVarsInData(bayesPm.getVariables(), dataSet);
        MlBayesIm estimatedIm = new MlBayesIm(bayesPm);
        List<Node> variables = estimatedIm.getVariables();
        DataSet columnDataSet2 = dataSet.subsetColumns(variables);
        DataSetProbs discreteProbs = new DataSetProbs(columnDataSet2);
        Proposition assertion = Proposition.tautology(estimatedIm);
        Proposition condition = Proposition.tautology(estimatedIm);
        Evidence evidence2 = Evidence.tautology(estimatedIm);
        int numNodes = estimatedIm.getNumNodes();
        for (int node = 0; node < numNodes; ++node) {
            int numRows = estimatedIm.getNumRows(node);
            int numCols = estimatedIm.getNumColumns(node);
            int[] parents = estimatedIm.getParents(node);
            for (int row = 0; row < numRows; ++row) {
                int[] parentValues = estimatedIm.getParentValues(node, row);
                for (int col = 0; col < numCols; ++col) {
                    assertion.setToTautology();
                    condition.setToTautology();
                    for (int i = 0; i < numNodes; ++i) {
                        for (int j = 0; j < evidence2.getNumCategories(i); ++j) {
                            if (evidence2.getProposition().isAllowed(i, j)) continue;
                            condition.removeCategory(i, j);
                        }
                    }
                    assertion.disallowComplement(node, col);
                    for (int k = 0; k < parents.length; ++k) {
                        condition.disallowComplement(parents[k], parentValues[k]);
                    }
                    if (condition.existsCombination()) {
                        double p = discreteProbs.getConditionalProb(assertion, condition);
                        estimatedIm.setProbability(node, row, col, p);
                        continue;
                    }
                    estimatedIm.setProbability(node, row, col, Double.NaN);
                }
            }
        }
        return estimatedIm;
    }
}

