/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesImProbs;
import edu.cmu.tetrad.bayes.DiscreteProbs;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradSerializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class StoredCellProbs
implements TetradSerializable,
DiscreteProbs {
    static final long serialVersionUID = 23L;
    private final List<Node> variables;
    private final int[] parentDims;
    private final double[] probs;

    private StoredCellProbs(List<Node> variables) {
        if (variables == null) {
            throw new NullPointerException();
        }
        for (Node variable : variables) {
            if (variable == null) {
                throw new NullPointerException();
            }
            if (variable instanceof DiscreteVariable) continue;
            throw new IllegalArgumentException("Not a discrete variable: " + variable.getClass());
        }
        this.variables = Collections.unmodifiableList(variables);
        HashSet<Node> variableSet = new HashSet<Node>(this.variables);
        if (variableSet.size() < this.variables.size()) {
            throw new IllegalArgumentException("Duplicate variable.");
        }
        this.parentDims = new int[this.getVariables().size()];
        for (int i = 0; i < this.getVariables().size(); ++i) {
            DiscreteVariable var = (DiscreteVariable)this.getVariables().get(i);
            this.parentDims[i] = var.getNumCategories();
        }
        int numCells = 1;
        for (int parentDim : this.parentDims) {
            numCells *= parentDim;
        }
        this.probs = new double[numCells];
    }

    public static StoredCellProbs createRandomCellTable(List<Node> variables) {
        int i;
        StoredCellProbs cellProbs = new StoredCellProbs(variables);
        double sum = 0.0;
        for (i = 0; i < cellProbs.probs.length; ++i) {
            double value;
            cellProbs.probs[i] = value = RandomUtil.getInstance().nextDouble();
            sum += value;
        }
        i = 0;
        while (i < cellProbs.probs.length) {
            int n = i++;
            cellProbs.probs[n] = cellProbs.probs[n] / sum;
        }
        return cellProbs;
    }

    public static StoredCellProbs createCellTable(BayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        BayesImProbs cellProbsOnTheFly = new BayesImProbs(bayesIm);
        StoredCellProbs cellProbs = new StoredCellProbs(cellProbsOnTheFly.getVariables());
        for (int i = 0; i < cellProbs.probs.length; ++i) {
            int[] variableValues = cellProbs.getVariableValues(i);
            double p = cellProbsOnTheFly.getCellProb(variableValues);
            cellProbs.setCellProbability(variableValues, p);
        }
        return cellProbs;
    }

    public static StoredCellProbs serializableInstance() {
        return new StoredCellProbs(new ArrayList<Node>());
    }

    @Override
    public double getCellProb(int[] variableValues) {
        return this.probs[this.getOffset(variableValues)];
    }

    @Override
    public double getProb(Proposition assertion) {
        int[] variableValues = new int[assertion.getNumVariables()];
        for (int i = 0; i < assertion.getNumVariables(); ++i) {
            variableValues[i] = StoredCellProbs.nextValue(assertion, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double p = 0.0;
        block1: while (true) {
            for (int i = assertion.getNumVariables() - 1; i >= 0; --i) {
                if (!StoredCellProbs.hasNextValue(assertion, i, variableValues[i])) continue;
                variableValues[i] = StoredCellProbs.nextValue(assertion, i, variableValues[i]);
                for (int j = i + 1; j < assertion.getNumVariables(); ++j) {
                    if (!StoredCellProbs.hasNextValue(assertion, j, -1)) break block1;
                    variableValues[j] = StoredCellProbs.nextValue(assertion, j, -1);
                }
                p += this.getCellProb(variableValues);
            }
            break;
        }
        return p;
    }

    private static boolean hasNextValue(Proposition proposition, int variable, int curIndex) {
        return StoredCellProbs.nextValue(proposition, variable, curIndex) != -1;
    }

    private static int nextValue(Proposition proposition, int variable, int curIndex) {
        for (int i = curIndex + 1; i < proposition.getNumCategories(variable); ++i) {
            if (!proposition.isAllowed(variable, i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double getConditionalProb(Proposition assertion, Proposition condition) {
        if (assertion.getVariableSource() != condition.getVariableSource()) {
            throw new IllegalArgumentException("Assertion and condition must be for the same Bayes IM.");
        }
        int[] variableValues = new int[condition.getNumVariables()];
        for (int i = 0; i < condition.getNumVariables(); ++i) {
            variableValues[i] = StoredCellProbs.nextValue(condition, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double conditionTrue = 0.0;
        double assertionTrue = 0.0;
        block1: while (true) {
            for (int i = condition.getNumVariables() - 1; i >= 0; --i) {
                if (!StoredCellProbs.hasNextValue(condition, i, variableValues[i])) continue;
                variableValues[i] = StoredCellProbs.nextValue(condition, i, variableValues[i]);
                for (int j = i + 1; j < condition.getNumVariables(); ++j) {
                    if (!StoredCellProbs.hasNextValue(condition, j, -1)) break block1;
                    variableValues[j] = StoredCellProbs.nextValue(condition, j, -1);
                }
                double cellProb = this.getCellProb(variableValues);
                boolean assertionHolds = true;
                for (int j = 0; j < assertion.getNumVariables(); ++j) {
                    if (assertion.isAllowed(j, variableValues[j])) continue;
                    assertionHolds = false;
                    break;
                }
                if (assertionHolds) {
                    assertionTrue += cellProb;
                }
                conditionTrue += cellProb;
            }
            break;
        }
        return assertionTrue / conditionTrue;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        buf.append("\nCell Probabilities:");
        buf.append("\n");
        for (Node variable : this.variables) {
            buf.append(variable).append("\t");
        }
        double sum = 0.0;
        int maxLines = 500;
        for (int i = 0; i < this.probs.length; ++i) {
            int[] variableValues;
            if (i >= 500) {
                buf.append("\nCowardly refusing to print more than ").append(500).append(" lines.");
                break;
            }
            buf.append("\n");
            for (int variableValue : variableValues = this.getVariableValues(i)) {
                buf.append(variableValue).append("\t");
            }
            buf.append(nf.format(this.probs[i]));
            sum += this.probs[i];
        }
        buf.append("\n\nSum = ").append(nf.format(sum));
        return buf.toString();
    }

    private int getOffset(int[] values) {
        int[] dim = this.getParentDims();
        int offset = 0;
        for (int i = 0; i < dim.length; ++i) {
            if (values[i] < 0 || values[i] >= dim[i]) {
                throw new IllegalArgumentException();
            }
            offset *= dim[i];
            offset += values[i];
        }
        return offset;
    }

    private int[] getVariableValues(int rowIndex) {
        int[] dims = this.getParentDims();
        int[] values = new int[dims.length];
        for (int i = dims.length - 1; i >= 0; --i) {
            values[i] = rowIndex % dims[i];
            rowIndex /= dims[i];
        }
        return values;
    }

    private int[] getParentDims() {
        return this.parentDims;
    }

    private void setCellProbability(int[] variableValues, double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("Probability not in [0.0, 1.0]: " + probability);
        }
        this.probs[this.getOffset((int[])variableValues)] = probability;
    }
}

