/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesImProbs;
import edu.cmu.tetrad.bayes.DiscreteProbs;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.MlBayesImObs;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradSerializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class StoredCellProbsObs
implements TetradSerializable,
DiscreteProbs {
    static final long serialVersionUID = 23L;
    private final List<Node> variables;
    private final int[] parentDims;
    private final double[] probs;

    public StoredCellProbsObs(List<Node> variables) {
        if (variables == null) {
            throw new NullPointerException();
        }
        for (Node variable : variables) {
            if (variable == null) {
                throw new NullPointerException();
            }
            if (variable instanceof DiscreteVariable) continue;
            throw new IllegalArgumentException("Not a discrete variable: " + variable.getClass());
        }
        this.variables = Collections.unmodifiableList(variables);
        HashSet<Node> variableSet = new HashSet<Node>(this.variables);
        if (variableSet.size() < this.variables.size()) {
            throw new IllegalArgumentException("Duplicate variable.");
        }
        this.parentDims = new int[this.getVariables().size()];
        for (int i = 0; i < this.getVariables().size(); ++i) {
            DiscreteVariable var = (DiscreteVariable)this.getVariables().get(i);
            this.parentDims[i] = var.getNumCategories();
        }
        int numCells = 1;
        for (int parentDim : this.parentDims) {
            if (numCells > 1000000) {
                throw new IllegalArgumentException("The number of rows in the probability table  is greater than 1,000,000 and cannot be represented.");
            }
            numCells *= parentDim;
        }
        this.probs = new double[numCells];
    }

    public static StoredCellProbsObs serializableInstance() {
        return new StoredCellProbsObs(new ArrayList<Node>());
    }

    public void clearCellTable() {
        Arrays.fill(this.probs, Double.NaN);
    }

    public void createCellTable(MlBayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        BayesImProbs cellProbsOnTheFly = new BayesImProbs(bayesIm);
        for (int i = 0; i < this.probs.length; ++i) {
            int[] variableValues = this.getVariableValues(i);
            Proposition targetProp = Proposition.tautology(bayesIm);
            for (int j = 0; j < variableValues.length; ++j) {
                String nodeName = this.getVariables().get(j).getName();
                Node node = bayesIm.getNode(nodeName);
                targetProp.setCategory(bayesIm.getNodeIndex(node), variableValues[j]);
            }
            this.probs[i] = cellProbsOnTheFly.getProb(targetProp);
        }
    }

    public void createCellTable(MlBayesImObs bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.probs.length; ++i) {
            this.probs[i] = bayesIm.getProbability(i);
        }
    }

    @Override
    public double getCellProb(int[] variableValues) {
        return this.probs[this.getOffset(variableValues)];
    }

    @Override
    public double getProb(Proposition assertion) {
        int[] variableValues = new int[assertion.getNumVariables()];
        for (int i = 0; i < assertion.getNumVariables(); ++i) {
            variableValues[i] = StoredCellProbsObs.nextValue(assertion, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double p = 0.0;
        block1: while (true) {
            for (int i = assertion.getNumVariables() - 1; i >= 0; --i) {
                if (!StoredCellProbsObs.hasNextValue(assertion, i, variableValues[i])) continue;
                variableValues[i] = StoredCellProbsObs.nextValue(assertion, i, variableValues[i]);
                for (int j = i + 1; j < assertion.getNumVariables(); ++j) {
                    if (!StoredCellProbsObs.hasNextValue(assertion, j, -1)) break block1;
                    variableValues[j] = StoredCellProbsObs.nextValue(assertion, j, -1);
                }
                double cellProb = this.getCellProb(variableValues);
                if (Double.isNaN(cellProb)) continue;
                p += cellProb;
            }
            break;
        }
        return p;
    }

    private static boolean hasNextValue(Proposition proposition, int variable, int curIndex) {
        return StoredCellProbsObs.nextValue(proposition, variable, curIndex) != -1;
    }

    private static int nextValue(Proposition proposition, int variable, int curIndex) {
        for (int i = curIndex + 1; i < proposition.getNumCategories(variable); ++i) {
            if (!proposition.isAllowed(variable, i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double getConditionalProb(Proposition assertion, Proposition condition) {
        if (assertion.getVariableSource() != condition.getVariableSource()) {
            throw new IllegalArgumentException("Assertion and condition must be for the same Bayes IM.");
        }
        int[] variableValues = new int[condition.getNumVariables()];
        for (int i = 0; i < condition.getNumVariables(); ++i) {
            variableValues[i] = StoredCellProbsObs.nextValue(condition, i, -1);
        }
        variableValues[variableValues.length - 1] = -1;
        double conditionTrue = 0.0;
        double assertionTrue = 0.0;
        block1: while (true) {
            for (int i = condition.getNumVariables() - 1; i >= 0; --i) {
                if (!StoredCellProbsObs.hasNextValue(condition, i, variableValues[i])) continue;
                variableValues[i] = StoredCellProbsObs.nextValue(condition, i, variableValues[i]);
                for (int j = i + 1; j < condition.getNumVariables(); ++j) {
                    if (!StoredCellProbsObs.hasNextValue(condition, j, -1)) break block1;
                    variableValues[j] = StoredCellProbsObs.nextValue(condition, j, -1);
                }
                double cellProb = this.getCellProb(variableValues);
                boolean assertionHolds = true;
                for (int j = 0; j < assertion.getNumVariables(); ++j) {
                    if (assertion.isAllowed(j, variableValues[j])) continue;
                    assertionHolds = false;
                    break;
                }
                if (assertionHolds) {
                    assertionTrue += cellProb;
                }
                conditionTrue += cellProb;
            }
            break;
        }
        return assertionTrue / conditionTrue;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    public int getNumRows() {
        return this.probs.length;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        buf.append("\nCell Probabilities:");
        buf.append("\n");
        for (Node variable : this.variables) {
            buf.append(variable).append("\t");
        }
        double sum = 0.0;
        int maxLines = 500;
        for (int i = 0; i < this.probs.length; ++i) {
            int[] variableValues;
            if (i >= 500) {
                buf.append("\nCowardly refusing to print more than ").append(500).append(" lines.");
                break;
            }
            buf.append("\n");
            for (int variableValue : variableValues = this.getVariableValues(i)) {
                buf.append(variableValue).append("\t");
            }
            buf.append(nf.format(this.probs[i]));
            sum += this.probs[i];
        }
        buf.append("\n\nSum = ").append(nf.format(sum));
        return buf.toString();
    }

    public int[] getVariableValues(int rowIndex) {
        int[] dims = this.getParentDims();
        int[] values = new int[dims.length];
        for (int i = dims.length - 1; i >= 0; --i) {
            values[i] = rowIndex % dims[i];
            rowIndex /= dims[i];
        }
        return values;
    }

    public void setCellProbability(int[] variableValues, double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("Probability not in [0.0, 1.0]: " + probability);
        }
        this.probs[this.getOffset((int[])variableValues)] = probability;
    }

    private int getOffset(int[] values) {
        int[] dim = this.getParentDims();
        int offset = 0;
        for (int i = 0; i < dim.length; ++i) {
            if (values[i] < 0 || values[i] >= dim[i]) {
                throw new IllegalArgumentException();
            }
            offset *= dim[i];
            offset += values[i];
        }
        return offset;
    }

    private int[] getParentDims() {
        return this.parentDims;
    }
}

