/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.calculator.expression;

import edu.cmu.tetrad.calculator.expression.Context;
import edu.cmu.tetrad.calculator.expression.Expression;
import edu.cmu.tetrad.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetrad.calculator.expression.ExpressionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

abstract class AbstractExpression
implements Expression {
    static final long serialVersionUID = 23L;
    private final List<Expression> expressions;
    private final ExpressionDescriptor.Position position;
    private final String token;

    public AbstractExpression(String token, ExpressionDescriptor.Position position, Expression ... expressions) {
        this.position = position;
        this.token = token;
        this.expressions = Collections.unmodifiableList(Arrays.asList(expressions));
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public ExpressionDescriptor.Position getPosition() {
        return this.position;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public RealDistribution getRealDistribution(Context context) {
        if (this.expressions.size() == 1) {
            return this.expressions.get(0).getRealDistribution(context);
        }
        return null;
    }

    @Override
    public IntegerDistribution getIntegerDistribution(Context context) {
        if (this.expressions.size() == 1) {
            return this.expressions.get(0).getIntegerDistribution(context);
        }
        return null;
    }

    public String toString() {
        if (this.getPosition() != null && this.getToken() != null) {
            return ExpressionUtils.renderExpression(this, this.getPosition(), this.getToken());
        }
        return "No string representation available.";
    }
}

