/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.calculator.expression;

import edu.cmu.tetrad.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetrad.calculator.expression.ExpressionSignature;

abstract class AbstractExpressionDescriptor
implements ExpressionDescriptor {
    static final long serialVersionUID = 23L;
    private final String name;
    private final ExpressionDescriptor.Position position;
    private final String token;
    private final ExpressionSignature signature;
    private final boolean display;

    public AbstractExpressionDescriptor(String name, String token, ExpressionDescriptor.Position position, boolean unlimited) {
        if (name == null) {
            throw new NullPointerException("name was null.");
        }
        if (token == null) {
            throw new NullPointerException("token was null.");
        }
        if (position == null) {
            throw new NullPointerException("position was null.");
        }
        this.signature = new Signature(token, unlimited, false, token, "expr");
        this.name = name;
        this.token = token;
        this.position = position;
        this.display = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public ExpressionSignature getSignature() {
        return this.signature;
    }

    @Override
    public ExpressionDescriptor.Position getPosition() {
        return this.position;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public static class Signature
    implements ExpressionSignature {
        static final long serialVersionUID = 23L;
        private String signature;
        private final String[] arguments;

        public Signature(String function, boolean unlimited, boolean commulative, String ... arguments) {
            if (function == null) {
                throw new NullPointerException("function was null.");
            }
            this.arguments = arguments;
            this.signature = function;
            if (!commulative) {
                this.signature = this.signature + "(";
                for (int i = 0; i < arguments.length; ++i) {
                    if (i != 0) {
                        this.signature = this.signature + ", ";
                    }
                    this.signature = this.signature + arguments[i];
                }
                if (unlimited) {
                    if (arguments.length != 0) {
                        this.signature = this.signature + ", ";
                    }
                    this.signature = this.signature + "...";
                }
                this.signature = this.signature + ")";
            }
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        @Override
        public int getNumberOfArguments() {
            return this.arguments.length;
        }

        @Override
        public String getArgument(int index) {
            return this.arguments[index];
        }

        public static Signature serializableInstance() {
            return new Signature("+", true, false, "a");
        }
    }
}

