/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.calculator.expression;

import edu.cmu.tetrad.calculator.expression.Context;
import edu.cmu.tetrad.calculator.expression.Expression;
import edu.cmu.tetrad.calculator.expression.ExpressionDescriptor;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class VariableExpression
implements Expression {
    static final long serialVersionUID = 23L;
    private final String variable;

    public VariableExpression(String variable) {
        if (variable == null) {
            throw new NullPointerException("variable is null.");
        }
        this.variable = variable;
    }

    public static VariableExpression serializableInstance() {
        return new VariableExpression("a");
    }

    public String getVariable() {
        return this.variable;
    }

    public Double evaluateGeneric(Context context) {
        return context.getValue(this.variable);
    }

    @Override
    public double evaluate(Context context) {
        Double value = context.getValue(this.variable);
        if (value == null) {
            throw new IllegalArgumentException(this.variable + " was not assigned a value.");
        }
        return value;
    }

    @Override
    public String getToken() {
        return "";
    }

    @Override
    public ExpressionDescriptor.Position getPosition() {
        return ExpressionDescriptor.Position.NEITHER;
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.variable;
    }

    @Override
    public RealDistribution getRealDistribution(Context context) {
        return null;
    }

    @Override
    public IntegerDistribution getIntegerDistribution(Context context) {
        return null;
    }
}

