/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.calibration;

import edu.cmu.tetrad.calibration.DataForCalibration_RFCI;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.MillisecondTimes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

class BootstrapWorker
extends Thread {
    private static final int nprocessor = FastMath.max(Runtime.getRuntime().availableProcessors() - 1, 1);
    public static double alpha;
    public static int BootstrapNum;
    public static DataForCalibration_RFCI DFC;
    public static Graph truePag;
    public static List<Graph> BNfromBootstrap;
    public static List<BootstrapWorker> waitingList;
    public static List<BootstrapWorker> runningList;
    public DataSet bootstrapSample;
    public double start_time = -1.0;
    public double end_time = -1.0;

    public BootstrapWorker(DataSet bootstrapSample, List<Graph> BNfromBootstrap) {
        this.bootstrapSample = bootstrapSample;
        BootstrapWorker.BNfromBootstrap = BNfromBootstrap;
    }

    public static void addToWaitingList(BootstrapWorker worker) {
        waitingList.add(worker);
    }

    private static boolean check_resource_availability() {
        if (runningList.size() < nprocessor) {
            return true;
        }
        for (int i = 0; i < runningList.size(); ++i) {
            if (BootstrapWorker.runningList.get((int)i).end_time == -1.0) continue;
            runningList.remove(i);
            return true;
        }
        return false;
    }

    public static void executeThreads_and_wait() throws InterruptedException {
        for (BootstrapWorker t : waitingList) {
            while (!BootstrapWorker.check_resource_availability()) {
                long sleep_time = 3000L;
                Thread.sleep(sleep_time);
            }
            runningList.add(t);
            t.start();
        }
        for (BootstrapWorker t : runningList) {
            t.join();
        }
    }

    @Override
    public void run() {
        this.start_time = MillisecondTimes.timeMillis();
        Graph outGraph = DFC.learnBNRFCI(this.bootstrapSample, BootstrapWorker.DFC.depth, truePag);
        this.addToList(outGraph);
        this.end_time = MillisecondTimes.timeMillis();
    }

    public synchronized void addToList(Graph outGraph) {
        BNfromBootstrap.add(outGraph);
    }

    static {
        BootstrapNum = -1;
        waitingList = new ArrayList<BootstrapWorker>();
        runningList = new ArrayList<BootstrapWorker>();
    }
}

