/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NamingProtocol;

public abstract class AbstractVariable
implements Variable {
    static final long serialVersionUID = 23L;
    public static int LAST_ID;
    private String name;

    AbstractVariable(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name = name.trim();
    }

    @Override
    public abstract Object getMissingValueMarker();

    @Override
    public abstract boolean isMissingValue(Object var1);

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("AbstractVariable name must not be null.");
        }
        if (!NamingProtocol.isLegalName(name)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean checkValue(Object value) {
        return true;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public abstract Node like(String var1);

    @Override
    public int compareTo(Node node) {
        String node1 = this.getName();
        String node2 = node.getName();
        boolean isAlpha1 = Node.ALPHA.matcher(node1).matches();
        boolean isAlpha2 = Node.ALPHA.matcher(node2).matches();
        boolean isAlphaNum1 = Node.ALPHA_NUM.matcher(node1).matches();
        boolean isAlphaNum2 = Node.ALPHA_NUM.matcher(node2).matches();
        boolean isLag1 = Node.LAG.matcher(node1).matches();
        boolean isLag2 = Node.LAG.matcher(node2).matches();
        if (isAlpha1) {
            if (isLag2) {
                return -1;
            }
        } else if (isAlphaNum1) {
            if (isAlphaNum2) {
                String s2;
                String s1 = node1.replaceAll("\\d+", "");
                if (s1.equals(s2 = node2.replaceAll("\\d+", ""))) {
                    String n1 = node1.replaceAll("\\D+", "");
                    String n2 = node2.replaceAll("\\D+", "");
                    return Integer.valueOf(n1).compareTo(Integer.valueOf(n2));
                }
                return s1.compareTo(s2);
            }
            if (isLag2) {
                return -1;
            }
        } else if (isLag1) {
            if (isAlpha2 || isAlphaNum2) {
                return 1;
            }
            if (isLag2) {
                String s2;
                String l1 = node1.replaceAll(":", "");
                String l2 = node2.replaceAll(":", "");
                String s1 = l1.replaceAll("\\d+", "");
                if (s1.equals(s2 = l2.replaceAll("\\d+", ""))) {
                    String n1 = l1.replaceAll("\\D+", "");
                    String n2 = l2.replaceAll("\\D+", "");
                    return Integer.valueOf(n1).compareTo(Integer.valueOf(n2));
                }
                return s1.compareTo(s2);
            }
        }
        return node1.compareTo(node2);
    }
}

