/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;

public final class CaseExpander
implements DataFilter {
    @Override
    public DataSet filter(DataSet dataSet) {
        return CaseExpander.expand(dataSet);
    }

    private static DataSet expand(DataSet dataSet) {
        int rows = 0;
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            ++rows;
        }
        BoxDataSet newDataSet = new BoxDataSet(new VerticalDoubleDataBox(rows, dataSet.getVariables().size()), dataSet.getVariables());
        int cols = dataSet.getNumColumns();
        int index = -1;
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            ++index;
            for (int j = 0; j < cols; ++j) {
                if (dataSet.getVariable(j) instanceof ContinuousVariable) {
                    newDataSet.setDouble(index, j, dataSet.getDouble(i, j));
                    continue;
                }
                if (dataSet.getVariable(j) instanceof DiscreteVariable) {
                    newDataSet.setInt(index, j, dataSet.getInt(i, j));
                    continue;
                }
                throw new IllegalStateException("Expecting either a continuous or a discrete variable.");
            }
        }
        return newDataSet;
    }
}

