/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.util.MultiDimIntTable;

public final class CellTable {
    private int[] coordCopy;
    private int missingValue = -99;
    private final MultiDimIntTable table;

    public CellTable(int[] dims) {
        this.table = new MultiDimIntTable(dims);
    }

    public synchronized void addToTable(DataSet dataSet, int[] indices) {
        int[] dims = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(indices[i]);
            dims[i] = variable.getNumCategories();
        }
        this.table.reset(dims);
        int[] coords = new int[indices.length];
        block3: for (int i = 0; i < dataSet.getNumRows(); ++i) {
            for (int j = 0; j < indices.length; ++j) {
                try {
                    coords[j] = dataSet.getInt(i, indices[j]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    coords[j] = dataSet.getInt(i, j);
                }
                if (coords[j] == this.getMissingValue()) continue block3;
            }
            this.table.increment(coords, 1);
        }
    }

    public int getNumValues(int varIndex) {
        return this.table.getDims(varIndex);
    }

    public synchronized long calcMargin(int[] coords) {
        this.internalCoordCopy(coords);
        int sum = 0;
        int i = -1;
        while (++i < this.coordCopy.length) {
            if (this.coordCopy[i] != -1) continue;
            int j = 0;
            while (j < this.table.getDimension(i)) {
                this.coordCopy[i] = j++;
                sum = (int)((long)sum + this.calcMargin(this.coordCopy));
            }
            this.coordCopy[i] = -1;
            return sum;
        }
        return this.table.getValue(this.coordCopy);
    }

    public synchronized long calcMargin(int[] coords, int[] marginVars) {
        this.internalCoordCopy(coords);
        for (int marginVar : marginVars) {
            this.coordCopy[marginVar] = -1;
        }
        return this.calcMargin(this.coordCopy);
    }

    private synchronized void internalCoordCopy(int[] coords) {
        if (this.coordCopy == null || this.coordCopy.length != coords.length) {
            this.coordCopy = new int[coords.length];
        }
        System.arraycopy(coords, 0, this.coordCopy, 0, coords.length);
    }

    private int getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(int missingValue) {
        this.missingValue = missingValue;
    }

    public long getValue(int[] testCell) {
        return this.table.getValue(testCell);
    }
}

