/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class Clusters
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private final Map<String, Integer> clusters;
    private final Map<Integer, String> names;
    private int numClusters = -1;

    public Clusters() {
        this.clusters = new HashMap<String, Integer>();
        this.names = new HashMap<Integer, String>();
    }

    public Clusters(Clusters clusters) {
        this.clusters = new HashMap<String, Integer>(clusters.clusters);
        this.names = new HashMap<Integer, String>(clusters.names);
        this.numClusters = clusters.numClusters;
    }

    public static Clusters serializableInstance() {
        return new Clusters();
    }

    public void addToCluster(int index, String var) {
        if (this.isClustersBounded() && index >= this.getNumClusters()) {
            throw new IllegalArgumentException();
        }
        this.clusters.put(var, index);
    }

    public List<String> getVarsNotInCluster(List<String> varNames) {
        ArrayList<String> notInCluster = new ArrayList<String>(varNames);
        IntStream.range(0, this.getNumClusters()).mapToObj(this::getCluster).forEach(notInCluster::removeAll);
        return notInCluster;
    }

    public int getNumClusters() {
        if (!this.isClustersBounded()) {
            return this.numClustersStored();
        }
        return this.numClusters;
    }

    public void setNumClusters(int numClusters) {
        if (numClusters < -1) {
            throw new IllegalArgumentException();
        }
        this.numClusters = numClusters;
    }

    public Map<String, Integer> getClusters() {
        return new HashMap<String, Integer>(this.clusters);
    }

    public List<String> getCluster(int index) {
        if (this.isClustersBounded() && index > this.getNumClusters()) {
            throw new IllegalArgumentException();
        }
        LinkedList<String> cluster = new LinkedList<String>();
        for (String _varName : this.clusters.keySet()) {
            Integer _index = this.clusters.get(_varName);
            if (_index != index) continue;
            cluster.add(_varName);
        }
        Collections.sort(cluster);
        return cluster;
    }

    public String getClusterName(int index) {
        if (this.isClustersBounded() && index > this.getNumClusters()) {
            throw new IllegalArgumentException();
        }
        String name = this.names.get(index);
        if (name == null) {
            name = this.newClusterName();
            this.names.put(index, name);
        }
        return name;
    }

    private boolean isClustersBounded() {
        return this.numClusters != -1;
    }

    public synchronized void setClusterName(int index, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.isClustersBounded() && index > this.getNumClusters()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.getNumClusters(); ++i) {
            String _name;
            if (i == index || !name.equals(_name = this.names.get(i))) continue;
            throw new IllegalArgumentException("That is the name for cluster #" + (i + 1) + ": " + name);
        }
        this.names.put(index, name);
    }

    public void removeFromClusters(String var) {
        this.clusters.remove(var);
    }

    public int hashCode() {
        int hash = 37;
        return hash += 17 * this.clusters.hashCode() + 37;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Clusters)) {
            return false;
        }
        Clusters clusters = (Clusters)o;
        return this.clusters.equals(clusters.clusters);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Clusters:");
        for (int i = 0; i < this.getNumClusters(); ++i) {
            List<String> s = this.getCluster(i);
            buf.append("\n").append(i).append(":");
            for (String value : s) {
                buf.append("\t").append((Object)value);
            }
        }
        buf.append("\n");
        return buf.toString();
    }

    private String newClusterName() {
        String name;
        Collection<String> values = this.names.values();
        int i = 0;
        while (values.contains(name = "_L" + ++i)) {
        }
        return name;
    }

    private int numClustersStored() {
        Collection<Integer> collection = this.clusters.values();
        int max = 0;
        for (Integer cluster : collection) {
            if (cluster + 1 <= max) continue;
            max = cluster + 1;
        }
        return max;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.clusters == null) {
            throw new NullPointerException();
        }
    }

    public boolean isEmpty() {
        return this.clusters.keySet().isEmpty();
    }
}

