/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.DiscretizationSpec;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public final class ContinuousDiscretizationSpec
implements TetradSerializable,
DiscretizationSpec {
    static final long serialVersionUID = 23L;
    private final double[] breakpoints;
    private final List<String> categories;
    private int method;
    public static final int EVENLY_DISTRIBUTED_VALUES = 1;
    public static final int EVENLY_DISTRIBUTED_INTERVALS = 2;
    public static final int NONE = 3;

    public ContinuousDiscretizationSpec(double[] breakpoints, List<String> categories) {
        this(breakpoints, categories, 2);
    }

    public ContinuousDiscretizationSpec(double[] breakpoints, List<String> categories, int method) {
        if (breakpoints == null) {
            throw new NullPointerException();
        }
        if (method != 1 && method != 2 && method != 3) {
            throw new IllegalArgumentException();
        }
        this.breakpoints = breakpoints;
        this.categories = categories;
        this.method = method;
    }

    public static DiscretizationSpec serializableInstance() {
        return new ContinuousDiscretizationSpec(new double[0], new ArrayList<String>());
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        if (method != 1 && method != 2 && method != 3) {
            throw new IllegalArgumentException();
        }
        this.method = method;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public double[] getBreakpoints() {
        return this.breakpoints;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.breakpoints == null) {
            throw new NullPointerException();
        }
        if (this.categories == null) {
            throw new NullPointerException();
        }
        if (this.method != 1 && this.method != 2) {
            this.method = 2;
        }
    }
}

