/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.AbstractVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeEqualityMode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.NodeVariableType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;

public final class ContinuousVariable
extends AbstractVariable {
    static final long serialVersionUID = 23L;
    private static final double MISSING_VALUE = Double.NaN;
    private NodeType nodeType = NodeType.MEASURED;
    private NodeVariableType nodeVariableType = NodeVariableType.DOMAIN;
    private int centerX = -1;
    private int centerY = -1;
    private transient PropertyChangeSupport pcs;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public ContinuousVariable(String name) {
        super(name);
    }

    public ContinuousVariable(ContinuousVariable variable) {
        super(variable.getName());
        this.nodeType = variable.nodeType;
        this.centerX = variable.centerX;
        this.centerY = variable.centerY;
        this.nodeVariableType = this.getNodeVariableType();
    }

    public static ContinuousVariable serializableInstance() {
        return new ContinuousVariable("X");
    }

    @Override
    public boolean checkValue(Object value) {
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof String) {
            try {
                Double.parseDouble((String)value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Node like(String name) {
        ContinuousVariable continuousVariable = new ContinuousVariable(name);
        continuousVariable.setNodeType(this.getNodeType());
        return continuousVariable;
    }

    @Override
    public Object getMissingValueMarker() {
        return Double.NaN;
    }

    public static double getDoubleMissingValue() {
        return Double.NaN;
    }

    public static boolean isDoubleMissingValue(double value) {
        return Double.isNaN(value);
    }

    @Override
    public boolean isMissingValue(Object value) {
        if (value instanceof Double) {
            double doubleValue = (Double)value;
            return Double.isNaN(doubleValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (NodeEqualityMode.getEqualityType() == NodeEqualityMode.Type.OBJECT) {
            return super.hashCode();
        }
        if (NodeEqualityMode.getEqualityType() == NodeEqualityMode.Type.NAME) {
            return this.getName().hashCode();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ContinuousVariable)) {
            return false;
        }
        if (NodeEqualityMode.getEqualityType() == NodeEqualityMode.Type.OBJECT) {
            return o == this;
        }
        if (NodeEqualityMode.getEqualityType() == NodeEqualityMode.Type.NAME) {
            return this.getName().equals(((Node)o).getName());
        }
        throw new IllegalStateException();
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public int getCenterX() {
        return this.centerX;
    }

    @Override
    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    @Override
    public int getCenterY() {
        return this.centerY;
    }

    @Override
    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    @Override
    public void setCenter(int centerX, int centerY) {
        this.setCenterX(centerX);
        this.setCenterY(centerY);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.nodeType == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public NodeVariableType getNodeVariableType() {
        return this.nodeVariableType;
    }

    @Override
    public void setNodeVariableType(NodeVariableType nodeVariableType) {
        this.nodeVariableType = nodeVariableType;
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

