/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.stat.correlation.RealCovarianceMatrixForkJoin;

public class CovariancesDoubleForkJoin {
    static final long serialVersionUID = 23L;
    private final int numOfCols;
    private final double[][] covariances;

    public CovariancesDoubleForkJoin(double[][] data, boolean biasCorrected) {
        this.numOfCols = data[0].length;
        RealCovarianceMatrixForkJoin cov = new RealCovarianceMatrixForkJoin(data, 10 * Runtime.getRuntime().availableProcessors());
        this.covariances = cov.compute(biasCorrected);
    }

    public double covariance(int i, int j) {
        return this.covariances[i][j];
    }

    public int size() {
        return this.numOfCols;
    }

    public double[][] getMatrix() {
        int[] rows = new int[this.size()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        return this.getSubMatrix(rows, rows);
    }

    public double[][] getSubMatrix(int[] rows, int[] cols) {
        double[][] submatrix = new double[rows.length][cols.length];
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                submatrix[i][j] = this.covariances[rows[i]][cols[j]];
            }
        }
        return submatrix;
    }
}

