/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class DataModelList
extends AbstractList<DataModel>
implements DataModel {
    static final long serialVersionUID = 23L;
    private List<DataModel> modelList = new LinkedList<DataModel>();
    private DataModel selectedModel;
    private String name;
    private Knowledge knowledge = new Knowledge();

    public DataModelList() {
    }

    public DataModelList(DataModelList dataModelList) {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.modelList = new ArrayList<DataModel>(dataModelList);
            this.selectedModel = dataModelList.selectedModel;
            this.name = dataModelList.name;
            this.knowledge = dataModelList.knowledge.copy();
            return;
        }
    }

    public static DataModelList serializableInstance() {
        return new DataModelList();
    }

    @Override
    public DataModel get(int index) {
        return this.modelList.get(index);
    }

    @Override
    public int size() {
        return this.modelList.size();
    }

    @Override
    public List<Node> getVariables() {
        if (this.getSelectedModel() == null) {
            throw new NullPointerException();
        }
        return this.getSelectedModel().getVariables();
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge.copy();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge.copy();
    }

    @Override
    public List<String> getVariableNames() {
        if (this.getSelectedModel() == null) {
            throw new NullPointerException();
        }
        return this.getSelectedModel().getVariableNames();
    }

    @Override
    public void add(int index, DataModel element) {
        this.modelList.add(index, element);
    }

    @Override
    public boolean isEmpty() {
        return this.modelList.isEmpty();
    }

    public boolean containsEmptyData() {
        if (this.modelList.isEmpty()) {
            return true;
        }
        return this.modelList.get(0).getVariableNames().isEmpty();
    }

    public List<DataModel> getModelList() {
        return this.modelList;
    }

    @Override
    public DataModel remove(int index) {
        DataModel removedObject = this.modelList.remove(index);
        if (removedObject == this.selectedModel) {
            this.selectedModel = null;
        }
        return removedObject;
    }

    public DataModel getSelectedModel() {
        if (this.selectedModel != null) {
            return this.selectedModel;
        }
        if (this.modelList.size() > 0) {
            return this.modelList.get(0);
        }
        return null;
    }

    public void setSelectedModel(DataModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        if (this.modelList.contains(model)) {
            this.selectedModel = model;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Data Model List <");
        for (DataModel aModelList : this.modelList) {
            buf.append(aModelList).append(", ");
        }
        buf.append(">");
        return buf.toString();
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    @Override
    public boolean isMixed() {
        return false;
    }

    @Override
    public Node getVariable(String name) {
        return null;
    }

    @Override
    public DataModel copy() {
        return null;
    }

    @Override
    public int hashCode() {
        int hashcode = 17;
        return hashcode += 17 * this.name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DataModelList)) {
            return false;
        }
        DataModelList list = (DataModelList)o;
        return this.name.equals(list.name) && this.modelList.equals(list.modelList) && this.knowledge.equals(list.knowledge) && this.selectedModel.equals(list.selectedModel);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.modelList == null) {
            throw new NullPointerException();
        }
        if (this.knowledge == null) {
            throw new NullPointerException();
        }
    }
}

