/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;

public final class DataWriter {
    public static void writeRectangularData(DataSet dataSet, Writer out, char separator) throws IOException {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        StringBuilder buf = new StringBuilder();
        for (int col = 0; col < dataSet.getNumColumns(); ++col) {
            String name = dataSet.getVariable(col).getName();
            if (name.trim().equals("")) {
                name = "C" + (col - 1);
            }
            buf.append(name);
            if (col >= dataSet.getNumColumns() - 1) continue;
            buf.append(separator);
        }
        for (int row = 0; row < dataSet.getNumRows(); ++row) {
            buf.append("\n");
            for (int col = 0; col < dataSet.getNumColumns(); ++col) {
                Node variable = dataSet.getVariable(col);
                if (variable instanceof ContinuousVariable) {
                    double value = dataSet.getDouble(row, col);
                    if (ContinuousVariable.isDoubleMissingValue(value)) {
                        buf.append("*");
                    } else {
                        buf.append(nf.format(value));
                    }
                    if (col >= dataSet.getNumColumns() - 1) continue;
                    buf.append(separator);
                    continue;
                }
                if (!(variable instanceof DiscreteVariable)) continue;
                Object obj = dataSet.getObject(row, col);
                String val = obj == null ? "" : obj.toString();
                buf.append(val);
                if (col >= dataSet.getNumColumns() - 1) continue;
                buf.append(separator);
            }
        }
        buf.append("\n");
        out.write(buf.toString());
        out.close();
    }

    public static void writeCovMatrix(ICovarianceMatrix covMatrix, PrintWriter out, NumberFormat nf) {
        out.println(covMatrix.getSampleSize());
        List<String> variables = covMatrix.getVariableNames();
        int numVars = variables.size();
        int varCount = 0;
        for (String variable : variables) {
            if (++varCount < numVars) {
                out.print(variable);
                out.print("\t");
                continue;
            }
            out.println(variable);
        }
        for (int j = 0; j < numVars; ++j) {
            for (int i = 0; i <= j; ++i) {
                double value = covMatrix.getValue(i, j);
                if (Double.isNaN(value)) {
                    out.print("*");
                } else {
                    out.print(nf.format(value));
                }
                out.print(i < j ? "\t" : "\n");
            }
        }
        out.flush();
        out.close();
    }

    public static void saveKnowledge(Knowledge knowledge, Writer out) throws IOException {
        String to;
        String from;
        KnowledgeEdge pair;
        StringBuilder buf = new StringBuilder();
        buf.append("/knowledge");
        buf.append("\naddtemporal\n");
        for (int i = 0; i < knowledge.getNumTiers(); ++i) {
            String forbiddenWithin = knowledge.isTierForbiddenWithin(i) ? "*" : "";
            String onlyCanCauseNextTier = knowledge.isOnlyCanCauseNextTier(i) ? "-" : "";
            buf.append("\n").append(i + 1).append(forbiddenWithin).append(onlyCanCauseNextTier).append(" ");
            List<String> tier = knowledge.getTier(i);
            if (tier == null || tier.isEmpty()) continue;
            buf.append(" ");
            buf.append(String.join((CharSequence)" ", tier));
        }
        buf.append("\n\nforbiddirect");
        Iterator<KnowledgeEdge> i = knowledge.forbiddenEdgesIterator();
        while (i.hasNext()) {
            pair = i.next();
            from = pair.getFrom();
            if (knowledge.isForbiddenByTiers(from, to = pair.getTo())) continue;
            buf.append("\n").append(from).append(" ").append(to);
        }
        buf.append("\n\nrequiredirect");
        i = knowledge.requiredEdgesIterator();
        while (i.hasNext()) {
            pair = i.next();
            from = pair.getFrom();
            to = pair.getTo();
            buf.append("\n").append(from).append(" ").append(to);
        }
        out.write(buf.toString());
        out.flush();
    }
}

