/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousDiscretizationSpec;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteDiscretizationSpec;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DiscretizationSpec;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Discretizer {
    private final DataSet sourceDataSet;
    private final Map<Node, DiscretizationSpec> specs;
    private boolean variablesCopied = true;

    public Discretizer(DataSet dataSet) {
        this.sourceDataSet = dataSet;
        this.specs = new HashMap<Node, DiscretizationSpec>();
    }

    public Discretizer(DataSet dataSet, Map<Node, DiscretizationSpec> specs) {
        this.sourceDataSet = dataSet;
        this.specs = specs;
    }

    public void equalCounts(Node node, int numCategories) {
        if (node instanceof DiscreteVariable) {
            return;
        }
        String name = node.getName();
        int i = this.sourceDataSet.getVariables().indexOf(node);
        double[] data = this.sourceDataSet.getDoubleData().getColumn(i).toArray();
        double[] breakpoints = Discretizer.getEqualFrequencyBreakPoints(data, numCategories);
        List<String> categories = new DiscreteVariable(name, numCategories).getCategories();
        ContinuousDiscretizationSpec spec = new ContinuousDiscretizationSpec(breakpoints, categories);
        spec.setMethod(1);
        this.specs.put(node, spec);
    }

    public void equalIntervals(Node node, int numCategories) {
        if (node instanceof DiscreteVariable) {
            return;
        }
        String name = node.getName();
        int i = this.sourceDataSet.getVariables().indexOf(node);
        double[] data = this.sourceDataSet.getDoubleData().getColumn(i).toArray();
        double max = StatUtils.max(data);
        double min = StatUtils.min(data);
        double interval = (max - min) / (double)numCategories;
        double[] breakpoints = new double[numCategories - 1];
        for (int g = 0; g < numCategories - 1; ++g) {
            breakpoints[g] = min + (double)(g + 1) * interval;
        }
        List<String> categories = new DiscreteVariable(name, numCategories).getCategories();
        ContinuousDiscretizationSpec spec = new ContinuousDiscretizationSpec(breakpoints, categories);
        spec.setMethod(2);
        this.specs.put(node, spec);
    }

    public void setVariablesCopied(boolean unselectedVariabledCopied) {
        this.variablesCopied = unselectedVariabledCopied;
    }

    private boolean isVariablesCopied() {
        return this.variablesCopied;
    }

    public DataSet discretize() {
        LinkedList<Node> variables = new LinkedList<Node>();
        HashMap<DiscreteVariable, Node> replacementMapping = new HashMap<DiscreteVariable, Node>();
        for (int i = 0; i < this.sourceDataSet.getNumColumns(); ++i) {
            DiscreteVariable var;
            List<String> cats;
            DiscretizationSpec _spec;
            Node _node;
            TetradSerializable spec;
            Node variable = this.sourceDataSet.getVariable(i);
            if (variable instanceof ContinuousVariable) {
                spec = null;
                _node = null;
                for (Node node : this.specs.keySet()) {
                    if (!node.getName().equals(variable.getName())) continue;
                    _spec = this.specs.get(node);
                    spec = (ContinuousDiscretizationSpec)_spec;
                    _node = node;
                    break;
                }
                if (spec != null) {
                    if (spec.getMethod() == 3) {
                        variables.add(variable);
                        continue;
                    }
                    cats = spec.getCategories();
                    var = new DiscreteVariable(variable.getName(), cats);
                    replacementMapping.put(var, _node);
                    variables.add(var);
                    continue;
                }
                if (!this.isVariablesCopied()) continue;
                variables.add(variable);
                continue;
            }
            if (variable instanceof DiscreteVariable) {
                spec = null;
                _node = null;
                for (Node node : this.specs.keySet()) {
                    if (!node.getName().equals(variable.getName())) continue;
                    _spec = this.specs.get(node);
                    spec = (DiscreteDiscretizationSpec)_spec;
                    _node = node;
                    break;
                }
                if (spec != null) {
                    cats = ((DiscreteDiscretizationSpec)spec).getCategories();
                    var = new DiscreteVariable(_node.getName(), cats);
                    replacementMapping.put(var, _node);
                    variables.add(var);
                    continue;
                }
                if (!this.isVariablesCopied()) continue;
                variables.add(variable);
                continue;
            }
            if (!this.isVariablesCopied()) continue;
            variables.add(variable);
        }
        BoxDataSet newDataSet = new BoxDataSet(new VerticalDoubleDataBox(this.sourceDataSet.getNumRows(), variables.size()), variables);
        for (int i = 0; i < newDataSet.getNumColumns(); ++i) {
            Node variable = newDataSet.getVariable(i);
            Node sourceVar = (Node)replacementMapping.get(variable);
            if (sourceVar != null && this.specs.containsKey(sourceVar)) {
                TetradSerializable spec;
                if (sourceVar instanceof ContinuousVariable) {
                    spec = (ContinuousDiscretizationSpec)this.specs.get(sourceVar);
                    double[] breakpoints = ((ContinuousDiscretizationSpec)spec).getBreakpoints();
                    List<String> categories = ((ContinuousDiscretizationSpec)spec).getCategories();
                    String name = variable.getName();
                    double[] trimmedData = new double[newDataSet.getNumRows()];
                    int col = newDataSet.getColumn(variable);
                    for (int j = 0; j < this.sourceDataSet.getNumRows(); ++j) {
                        trimmedData[j] = this.sourceDataSet.getDouble(j, col);
                    }
                    Discretization discretization = Discretizer.discretize(trimmedData, breakpoints, name, categories);
                    int _col = newDataSet.getColumn(variable);
                    int[] _data = discretization.getData();
                    for (int j = 0; j < _data.length; ++j) {
                        newDataSet.setInt(j, _col, _data[j]);
                    }
                    continue;
                }
                if (!(sourceVar instanceof DiscreteVariable)) continue;
                spec = (DiscreteDiscretizationSpec)this.specs.get(sourceVar);
                int[] remap = ((DiscreteDiscretizationSpec)spec).getRemap();
                int[] trimmedData = new int[newDataSet.getNumRows()];
                int col = newDataSet.getColumn(variable);
                for (int j = 0; j < this.sourceDataSet.getNumRows(); ++j) {
                    trimmedData[j] = this.sourceDataSet.getInt(j, col);
                }
                int _col = newDataSet.getColumn(variable);
                for (int j = 0; j < trimmedData.length; ++j) {
                    newDataSet.setInt(j, _col, remap[trimmedData[j]]);
                }
                continue;
            }
            DataUtils.copyColumn(variable, this.sourceDataSet, newDataSet);
        }
        return newDataSet;
    }

    public static double[] getEqualFrequencyBreakPoints(double[] _data, int numberOfCategories) {
        double[] data = new double[_data.length];
        System.arraycopy(_data, 0, data, 0, data.length);
        Arrays.sort(data);
        int n = data.length / numberOfCategories;
        double[] breakpoints = new double[numberOfCategories - 1];
        for (int i = 0; i < breakpoints.length; ++i) {
            breakpoints[i] = data[n * (i + 1)];
        }
        return breakpoints;
    }

    public static Discretization discretize(double[] _data, double[] cutoffs, String variableName, List<String> categories) {
        if (cutoffs == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < cutoffs.length - 1; ++i) {
            if (cutoffs[i] <= cutoffs[i + 1]) continue;
            System.out.println("Cutoffs should be in nondecreasing order: " + Arrays.toString(cutoffs));
        }
        if (variableName == null) {
            throw new NullPointerException();
        }
        int numCategories = cutoffs.length + 1;
        if (categories != null && categories.size() != numCategories) {
            throw new IllegalArgumentException("If specified, the list of categories names must be one longer than the length of the cutoffs array.");
        }
        DiscreteVariable variable = categories == null ? new DiscreteVariable(variableName, numCategories) : new DiscreteVariable(variableName, categories);
        int[] discreteData = new int[_data.length];
        block1: for (int i = 0; i < _data.length; ++i) {
            if (Double.isNaN(_data[i])) {
                discreteData[i] = -99;
                continue;
            }
            for (int j = 0; j < cutoffs.length; ++j) {
                if (!(_data[i] > Double.NEGATIVE_INFINITY) || !(_data[i] < Double.POSITIVE_INFINITY) || !(_data[i] < cutoffs[j])) continue;
                discreteData[i] = j;
                continue block1;
            }
            discreteData[i] = cutoffs.length;
        }
        return new Discretization(variable, discreteData);
    }

    public static class Discretization {
        private final DiscreteVariable variable;
        private final int[] data;

        private Discretization(DiscreteVariable variable, int[] data) {
            this.variable = variable;
            this.data = data;
        }

        public final DiscreteVariable getVariable() {
            return this.variable;
        }

        public final int[] getData() {
            return this.data;
        }

        public final String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("\n\nDiscretization:");
            for (int aData : this.data) {
                buf.append("\n").append(this.variable.getCategory(aData));
            }
            buf.append("\n");
            return buf.toString();
        }
    }
}

