/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.ShortDataBox;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;

public class FloatDataBox
implements DataBox {
    static final long serialVersionUID = 23L;
    private final float[][] data;

    private FloatDataBox(int rows, int cols) {
        this.data = new float[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data[i][j] = Float.NaN;
            }
        }
    }

    public FloatDataBox(float[][] data) {
        int length = data[0].length;
        for (float[] datum : data) {
            if (datum.length == length) continue;
            throw new IllegalArgumentException("All rows must have same length.");
        }
        this.data = data;
    }

    public static BoxDataSet serializableInstance() {
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < 4; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        return new BoxDataSet(new ShortDataBox(4, 4), vars);
    }

    @Override
    public int numRows() {
        return this.data.length;
    }

    @Override
    public int numCols() {
        return this.data[0].length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int row, int col, Number value) {
        if (value == null) {
            float[][] fArray = this.data;
            synchronized (this.data) {
                this.data[row][col] = Float.NaN;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        float[][] fArray = this.data;
        synchronized (this.data) {
            this.data[row][col] = value.floatValue();
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Number get(int row, int col) {
        float datum = this.data[row][col];
        if (Double.isNaN(datum)) {
            return null;
        }
        return Float.valueOf(datum);
    }

    @Override
    public DataBox copy() {
        FloatDataBox box = new FloatDataBox(this.numRows(), this.numCols());
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numCols(); ++j) {
                box.set(i, j, this.get(i, j));
            }
        }
        return box;
    }

    @Override
    public DataBox like() {
        int[] rows = new int[this.numRows()];
        int[] cols = new int[this.numCols()];
        for (int i = 0; i < this.numRows(); ++i) {
            rows[i] = i;
        }
        for (int j = 0; j < this.numCols(); ++j) {
            cols[j] = j;
        }
        return this.viewSelection(rows, cols);
    }

    @Override
    public DataBox viewSelection(int[] rows, int[] cols) {
        FloatDataBox _dataBox = new FloatDataBox(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                _dataBox.set(i, j, this.get(rows[i], cols[j]));
            }
        }
        return _dataBox;
    }
}

