/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.data.KnowledgeGroup;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.OrderedPair;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Knowledge
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private static final Pattern VARNAME_PATTERN = Pattern.compile("[A-Za-z0-9:_\\-.]+");
    private static final Pattern SPEC_PATTERN = Pattern.compile("[A-Za-z0-9:-_,\\-.*]+");
    private static final Pattern COMMAN_DELIM = Pattern.compile(",");
    private final Set<String> variables;
    private final List<OrderedPair<Set<String>>> forbiddenRulesSpecs;
    private final List<OrderedPair<Set<String>>> requiredRulesSpecs;
    private final List<Set<String>> tierSpecs;
    private final List<KnowledgeGroup> knowledgeGroups;
    private final Map<KnowledgeGroup, OrderedPair<Set<String>>> knowledgeGroupRules;
    private boolean defaultToKnowledgeLayout;

    public Knowledge() {
        this.variables = new HashSet<String>();
        this.forbiddenRulesSpecs = new ArrayList<OrderedPair<Set<String>>>();
        this.requiredRulesSpecs = new ArrayList<OrderedPair<Set<String>>>();
        this.tierSpecs = new ArrayList<Set<String>>();
        this.knowledgeGroups = new LinkedList<KnowledgeGroup>();
        this.knowledgeGroupRules = new HashMap<KnowledgeGroup, OrderedPair<Set<String>>>();
    }

    public Knowledge(Collection<String> nodes) {
        this();
        nodes.forEach(node -> {
            if (!this.checkVarName((String)node)) {
                throw new IllegalArgumentException(String.format("Bad variable node %s.", node));
            }
            this.variables.add((String)node);
        });
    }

    public Knowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new IllegalArgumentException("Knowledge is null.");
        }
        try {
            Knowledge copy = new MarshalledObject<Knowledge>(knowledge).get();
            this.defaultToKnowledgeLayout = copy.defaultToKnowledgeLayout;
            this.variables = copy.variables;
            this.forbiddenRulesSpecs = copy.forbiddenRulesSpecs;
            this.requiredRulesSpecs = copy.requiredRulesSpecs;
            this.tierSpecs = copy.tierSpecs;
            this.knowledgeGroups = copy.knowledgeGroups;
            this.knowledgeGroupRules = copy.knowledgeGroupRules;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Knowledge serializableInstance() {
        return new Knowledge();
    }

    private boolean checkVarName(String name) {
        return true;
    }

    private String checkSpec(String spec) {
        return spec.replace(".", "\\.");
    }

    private Set<String> getExtent(String spec) {
        HashSet<String> vars = new HashSet<String>();
        if (spec.contains("*")) {
            this.split(spec).stream().map(e -> e.replace("*", ".*")).forEach(e -> {
                Pattern cpdag = Pattern.compile(e);
                this.variables.stream().filter(var -> cpdag.matcher((CharSequence)var).matches()).collect(Collectors.toCollection(() -> vars));
            });
        } else if (this.variables.contains(spec)) {
            vars.add(spec);
        }
        return vars;
    }

    private Set<String> split(String spec) {
        return Arrays.stream(COMMAN_DELIM.split(spec)).map(String::trim).filter(e -> !e.isEmpty()).collect(Collectors.toSet());
    }

    private void ensureTiers(int tier) {
        for (int i = this.tierSpecs.size(); i <= tier; ++i) {
            this.tierSpecs.add(new LinkedHashSet());
            for (int j = 0; j < i; ++j) {
                this.forbiddenRulesSpecs.add(new OrderedPair<Set<String>>(this.tierSpecs.get(i), this.tierSpecs.get(j)));
            }
        }
    }

    private OrderedPair<Set<String>> getGroupRule(KnowledgeGroup group) {
        HashSet fromExtent = new HashSet();
        group.getFromVariables().forEach(e -> fromExtent.addAll(this.getExtent((String)e)));
        HashSet toExtent = new HashSet();
        group.getToVariables().forEach(e -> toExtent.addAll(this.getExtent((String)e)));
        return new OrderedPair<Set<String>>(fromExtent, toExtent);
    }

    private Set<OrderedPair<Set<String>>> forbiddenTierRules() {
        int j;
        int i;
        HashSet<OrderedPair<Set<String>>> rules = new HashSet<OrderedPair<Set<String>>>();
        for (i = 0; i < this.tierSpecs.size(); ++i) {
            if (!this.isTierForbiddenWithin(i)) continue;
            rules.add(new OrderedPair<Set<String>>(this.tierSpecs.get(i), this.tierSpecs.get(i)));
        }
        for (i = 0; i < this.tierSpecs.size(); ++i) {
            if (!this.isOnlyCanCauseNextTier(i)) continue;
            for (j = i + 2; j < this.tierSpecs.size(); ++j) {
                rules.add(new OrderedPair<Set<String>>(this.tierSpecs.get(i), this.tierSpecs.get(j)));
            }
        }
        for (i = 0; i < this.tierSpecs.size(); ++i) {
            for (j = i + 1; j < this.tierSpecs.size(); ++j) {
                rules.add(new OrderedPair<Set<String>>(this.tierSpecs.get(j), this.tierSpecs.get(i)));
            }
        }
        return rules;
    }

    public void addToTier(int tier, String spec) {
        if (tier < 0) {
            throw new IllegalArgumentException();
        }
        if (spec == null) {
            throw new NullPointerException();
        }
        this.addVariable(spec);
        spec = this.checkSpec(spec);
        this.ensureTiers(tier);
        this.getExtent(spec).stream().filter(this::checkVarName).forEach(e -> {
            this.variables.add((String)e);
            this.tierSpecs.get(tier).add((String)e);
        });
    }

    public void addToTiersByVarNames(List<String> varNames) {
        if (!this.variables.containsAll(varNames)) {
            varNames.forEach(e -> {
                if (!this.checkVarName((String)e)) {
                    throw new IllegalArgumentException(String.format("Bad variable node %s.", e));
                }
                this.variables.add((String)e);
            });
        }
        varNames.forEach(e -> {
            int index = e.lastIndexOf(":t");
            if (index >= 0) {
                this.addToTier(Integer.parseInt(e.substring(index + 2)), (String)e);
            }
        });
    }

    public void addKnowledgeGroup(KnowledgeGroup group) {
        this.knowledgeGroups.add(group);
        OrderedPair<Set<String>> o = this.getGroupRule(group);
        this.knowledgeGroupRules.put(group, o);
        if (group.getType() == 2) {
            this.forbiddenRulesSpecs.add(o);
        } else if (group.getType() == 1) {
            this.requiredRulesSpecs.add(o);
        }
    }

    public void addVariable(String varName) {
        this.variables.add(varName);
    }

    public void clear() {
        this.variables.clear();
        this.forbiddenRulesSpecs.clear();
        this.requiredRulesSpecs.clear();
        this.tierSpecs.clear();
    }

    public Iterator<KnowledgeEdge> forbiddenEdgesIterator() {
        HashSet edges = new HashSet();
        this.forbiddenRulesSpecs.forEach(o -> ((Set)o.getFirst()).forEach(s1 -> ((Set)o.getSecond()).forEach(s2 -> {
            if (!s1.equals(s2)) {
                edges.add(new KnowledgeEdge((String)s1, (String)s2));
            }
        })));
        return edges.iterator();
    }

    public List<KnowledgeGroup> getKnowledgeGroups() {
        return new ArrayList<KnowledgeGroup>(this.knowledgeGroups);
    }

    public List<String> getVariables() {
        return this.variables.stream().sorted().collect(Collectors.toList());
    }

    public List<String> getVariablesNotInTiers() {
        ArrayList<String> notInTier = new ArrayList<String>(this.variables);
        for (Set<String> tier : this.tierSpecs) {
            notInTier.removeAll(tier);
        }
        return notInTier;
    }

    public List<String> getTier(int tier) {
        this.ensureTiers(tier);
        try {
            return this.tierSpecs.get(tier).stream().sorted().collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected knowledge configuration.", e);
        }
    }

    public int getNumTiers() {
        return this.tierSpecs.size();
    }

    public boolean isDefaultToKnowledgeLayout() {
        return this.defaultToKnowledgeLayout;
    }

    public void setDefaultToKnowledgeLayout(boolean defaultToKnowledgeLayout) {
        this.defaultToKnowledgeLayout = defaultToKnowledgeLayout;
    }

    private boolean isForbiddenByRules(String var1, String var2) {
        return this.forbiddenRulesSpecs.stream().anyMatch(rule -> !var1.equals(var2) && ((Set)rule.getFirst()).contains(var1) && ((Set)rule.getSecond()).contains(var2));
    }

    public boolean isForbidden(String var1, String var2) {
        if (this.isRequired(var1, var2)) {
            return false;
        }
        return this.isForbiddenByRules(var1, var2) || this.isForbiddenByTiers(var1, var2);
    }

    public boolean isForbiddenByGroups(String var1, String var2) {
        Set s = this.knowledgeGroups.stream().filter(e -> e.getType() == 2).map(this::getGroupRule).collect(Collectors.toSet());
        return s.stream().anyMatch(rule -> ((Set)rule.getFirst()).contains(var1) && ((Set)rule.getSecond()).contains(var2));
    }

    public boolean isForbiddenByTiers(String var1, String var2) {
        return this.forbiddenTierRules().stream().anyMatch(rule -> ((Set)rule.getFirst()).contains(var1) && ((Set)rule.getSecond()).contains(var2));
    }

    public boolean isRequired(String var1, String var2) {
        return this.requiredRulesSpecs.stream().anyMatch(rule -> !var1.equals(var2) && ((Set)rule.getFirst()).contains(var1) && ((Set)rule.getSecond()).contains(var2));
    }

    public boolean isRequiredByGroups(String var1, String var2) {
        Set s = this.knowledgeGroups.stream().filter(e -> e.getType() == 1).map(this::getGroupRule).collect(Collectors.toSet());
        return s.stream().anyMatch(rule -> ((Set)rule.getFirst()).contains(var1) && ((Set)rule.getSecond()).contains(var2));
    }

    public boolean isEmpty() {
        return this.forbiddenRulesSpecs.isEmpty() && this.requiredRulesSpecs.isEmpty() && this.tierSpecs.isEmpty();
    }

    public boolean isTierForbiddenWithin(int tier) {
        this.ensureTiers(tier);
        Set<String> varsInTier = this.tierSpecs.get(tier);
        if (varsInTier.isEmpty()) {
            return false;
        }
        return this.forbiddenRulesSpecs.contains(new OrderedPair<Set<String>>(varsInTier, varsInTier));
    }

    public boolean isViolatedBy(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Sorry, a graph hasn't been provided.");
        }
        return graph.getEdges().stream().filter(Edge::isDirected).anyMatch(edge -> {
            Node from = Edges.getDirectedEdgeTail(edge);
            Node to = Edges.getDirectedEdgeHead(edge);
            return this.isForbidden(from.getName(), to.getName());
        });
    }

    public boolean noEdgeRequired(String x, String y) {
        return !this.isRequired(x, y) && !this.isRequired(y, x);
    }

    public void removeFromTiers(String spec) {
        if (spec == null) {
            throw new NullPointerException();
        }
        spec = this.checkSpec(spec);
        this.getExtent(spec).forEach(s -> this.tierSpecs.forEach(tier -> tier.remove(s)));
    }

    public void removeKnowledgeGroup(int index) {
        OrderedPair<Set<String>> old = this.knowledgeGroupRules.get(this.knowledgeGroups.get(index));
        this.forbiddenRulesSpecs.remove(old);
        this.requiredRulesSpecs.remove(old);
        this.knowledgeGroups.remove(index);
    }

    public Iterator<KnowledgeEdge> requiredEdgesIterator() {
        HashSet edges = new HashSet();
        this.requiredRulesSpecs.forEach(o -> ((Set)o.getFirst()).forEach(s1 -> ((Set)o.getSecond()).forEach(s2 -> {
            if (!s1.equals(s2)) {
                edges.add(new KnowledgeEdge((String)s1, (String)s2));
            }
        })));
        return edges.iterator();
    }

    public void setForbidden(String var1, String var2) {
        if (this.isForbidden(var1, var2)) {
            return;
        }
        this.addVariable(var1);
        this.addVariable(var2);
        var1 = this.checkSpec(var1);
        var2 = this.checkSpec(var2);
        Set<String> f1 = this.getExtent(var1);
        Set<String> f2 = this.getExtent(var2);
        this.forbiddenRulesSpecs.add(new OrderedPair<Set<String>>(f1, f2));
    }

    public void removeForbidden(String var1, String var2) {
        var1 = this.checkSpec(var1);
        var2 = this.checkSpec(var2);
        Set<String> f1 = this.getExtent(var1);
        Set<String> f2 = this.getExtent(var2);
        this.forbiddenRulesSpecs.remove(new OrderedPair<Set<String>>(f1, f2));
    }

    public void setRequired(String var1, String var2) {
        this.addVariable(var1);
        this.addVariable(var2);
        var1 = this.checkSpec(var1);
        var2 = this.checkSpec(var2);
        Set<String> f1 = this.getExtent(var1);
        Set<String> f2 = this.getExtent(var2);
        f1.forEach(s -> {
            if (this.checkVarName((String)s)) {
                this.variables.add((String)s);
            }
        });
        f2.forEach(s -> {
            if (this.checkVarName((String)s)) {
                this.variables.add((String)s);
            }
        });
        this.requiredRulesSpecs.add(new OrderedPair<Set<String>>(f1, f2));
    }

    public void removeRequired(String var1, String var2) {
        var1 = this.checkSpec(var1);
        var2 = this.checkSpec(var2);
        Set<String> f1 = this.getExtent(var1);
        Set<String> f2 = this.getExtent(var2);
        this.requiredRulesSpecs.remove(new OrderedPair<Set<String>>(f1, f2));
    }

    public void setKnowledgeGroup(int index, KnowledgeGroup group) {
        OrderedPair<Set<String>> o = this.getGroupRule(group);
        OrderedPair<Set<String>> old = this.knowledgeGroupRules.get(this.knowledgeGroups.get(index));
        this.forbiddenRulesSpecs.remove(old);
        this.requiredRulesSpecs.remove(old);
        if (group.getType() == 2) {
            this.forbiddenRulesSpecs.add(o);
        } else if (group.getType() == 1) {
            this.requiredRulesSpecs.add(o);
        }
        this.knowledgeGroups.set(index, group);
    }

    public void setTier(int tier, List<String> vars) {
        this.ensureTiers(tier);
        Set<String> varsInTier = this.tierSpecs.get(tier);
        if (varsInTier != null) {
            varsInTier.clear();
        }
        vars.forEach(var -> this.addToTier(tier, (String)var));
    }

    public void setTierForbiddenWithin(int tier, boolean forbidden) {
        this.ensureTiers(tier);
        Set<String> varsInTier = this.tierSpecs.get(tier);
        if (forbidden) {
            this.forbiddenRulesSpecs.add(new OrderedPair<Set<String>>(varsInTier, varsInTier));
        } else {
            this.forbiddenRulesSpecs.remove(new OrderedPair<Set<String>>(varsInTier, varsInTier));
        }
    }

    public int getMaxTierForbiddenWithin() {
        for (int tier = this.tierSpecs.size(); tier >= 0; --tier) {
            if (!this.isTierForbiddenWithin(tier)) continue;
            return tier;
        }
        return -1;
    }

    public Knowledge copy() {
        return new Knowledge(this);
    }

    public int isInWhichTier(Node node) {
        for (int i = 0; i < this.tierSpecs.size(); ++i) {
            Set<String> tier = this.tierSpecs.get(i);
            for (String myNode : tier) {
                if (!myNode.equals(node.getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public List<KnowledgeEdge> getListOfRequiredEdges() {
        LinkedHashSet edges = new LinkedHashSet();
        this.requiredRulesSpecs.forEach(e -> ((Set)e.getFirst()).forEach(e1 -> ((Set)e.getSecond()).forEach(e2 -> {
            if (!e1.equals(e2)) {
                edges.add(new KnowledgeEdge((String)e1, (String)e2));
            }
        })));
        return new ArrayList<KnowledgeEdge>(edges);
    }

    public List<KnowledgeEdge> getListOfExplicitlyRequiredEdges() {
        return this.getListOfRequiredEdges();
    }

    public List<KnowledgeEdge> getListOfForbiddenEdges() {
        LinkedHashSet edges = new LinkedHashSet();
        this.forbiddenRulesSpecs.forEach(e -> ((Set)e.getFirst()).forEach(e1 -> ((Set)e.getSecond()).forEach(e2 -> {
            if (!e1.equals(e2)) {
                edges.add(new KnowledgeEdge((String)e1, (String)e2));
            }
        })));
        return new ArrayList<KnowledgeEdge>(edges);
    }

    public List<KnowledgeEdge> getListOfExplicitlyForbiddenEdges() {
        HashSet<OrderedPair<Set<String>>> copy = new HashSet<OrderedPair<Set<String>>>(this.forbiddenRulesSpecs);
        copy.removeAll(this.forbiddenTierRules());
        this.knowledgeGroups.forEach(e -> copy.remove(this.knowledgeGroupRules.get(e)));
        HashSet edges = new HashSet();
        for (OrderedPair orderedPair : copy) {
            ((Set)orderedPair.getFirst()).forEach(e1 -> ((Set)e2.getSecond()).forEach(e2 -> edges.add(new KnowledgeEdge((String)e1, (String)e2))));
        }
        return new ArrayList<KnowledgeEdge>(edges);
    }

    public boolean isOnlyCanCauseNextTier(int tier) {
        this.ensureTiers(tier);
        Set<String> varsInTier = this.tierSpecs.get(tier);
        if (varsInTier.isEmpty()) {
            return false;
        }
        if (tier + 2 >= this.tierSpecs.size()) {
            return false;
        }
        for (int tierN = tier + 2; tierN < this.tierSpecs.size(); ++tierN) {
            Set<String> varsInTierN = this.tierSpecs.get(tierN);
            OrderedPair<Set<String>> o = new OrderedPair<Set<String>>(varsInTier, varsInTierN);
            if (this.forbiddenRulesSpecs.contains(o)) continue;
            return false;
        }
        return true;
    }

    public void setOnlyCanCauseNextTier(int tier, boolean onlyCausesNext) {
        this.ensureTiers(tier);
        Set<String> varsInTier = this.tierSpecs.get(tier);
        for (int tierN = tier + 2; tierN < this.tierSpecs.size(); ++tierN) {
            Set<String> varsInTierN = this.tierSpecs.get(tierN);
            if (onlyCausesNext) {
                this.forbiddenRulesSpecs.add(new OrderedPair<Set<String>>(varsInTier, varsInTierN));
                continue;
            }
            this.forbiddenRulesSpecs.remove(new OrderedPair<Set<String>>(varsInTier, varsInTierN));
        }
    }

    public int hashCode() {
        int hash = 37;
        hash += 17 * this.variables.hashCode() + 37;
        hash += 17 * this.forbiddenRulesSpecs.hashCode() + 37;
        hash += 17 * this.requiredRulesSpecs.hashCode() + 37;
        return hash += 17 * this.tierSpecs.hashCode() + 37;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Knowledge)) {
            return false;
        }
        Knowledge that = (Knowledge)o;
        return this.forbiddenRulesSpecs.equals(that.forbiddenRulesSpecs) && this.requiredRulesSpecs.equals(that.requiredRulesSpecs) && this.tierSpecs.equals(that.tierSpecs);
    }

    public String toString() {
        try {
            CharArrayWriter out = new CharArrayWriter();
            DataWriter.saveKnowledge(this, out);
            return out.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not render knowledge.");
        }
    }
}

