/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.ShortDataBox;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;

public class LongDataBox
implements DataBox {
    static final long serialVersionUID = 23L;
    private final long[][] data;
    private int numRows;
    private int numCols;

    private LongDataBox(int rows, int cols) {
        this.data = new long[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data[i][j] = -99L;
            }
        }
    }

    public LongDataBox(long[][] data) {
        int length = data[0].length;
        for (long[] datum : data) {
            if (datum.length == length) continue;
            throw new IllegalArgumentException("All rows must have same length.");
        }
        this.data = data;
        this.numCols = data[0].length;
        this.numRows = data.length;
    }

    public static BoxDataSet serializableInstance() {
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < 4; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        return new BoxDataSet(new ShortDataBox(4, 4), vars);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int row, int col, Number value) {
        if (value == null) {
            long[][] lArray = this.data;
            synchronized (this.data) {
                this.data[row][col] = -99L;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        long[][] lArray = this.data;
        synchronized (this.data) {
            this.data[row][col] = value.longValue();
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Number get(int row, int col) {
        long datum = this.data[row][col];
        if (datum == -99L) {
            return null;
        }
        return datum;
    }

    @Override
    public DataBox copy() {
        LongDataBox box = new LongDataBox(this.numRows(), this.numCols());
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numCols(); ++j) {
                box.set(i, j, this.get(i, j));
            }
        }
        return box;
    }

    @Override
    public DataBox like() {
        int[] rows = new int[this.numRows()];
        int[] cols = new int[this.numCols()];
        for (int i = 0; i < this.numRows(); ++i) {
            rows[i] = i;
        }
        for (int j = 0; j < this.numCols(); ++j) {
            cols[j] = j;
        }
        return this.viewSelection(rows, cols);
    }

    @Override
    public DataBox viewSelection(int[] rows, int[] cols) {
        LongDataBox _dataBox = new LongDataBox(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                _dataBox.set(i, j, this.get(rows[i], cols[j]));
            }
        }
        return _dataBox;
    }
}

