/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.ShortDataBox;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MixedDataBox
implements DataBox {
    private static final long serialVersionUID = 23L;
    private final List<Node> variables;
    private final int numRows;
    private double[][] continuousData;
    private int[][] discreteData;

    public MixedDataBox(List<Node> variables, int numRows) {
        this.variables = variables;
        this.numRows = numRows;
        this.continuousData = new double[variables.size()][];
        this.discreteData = new int[variables.size()][];
        for (int j = 0; j < variables.size(); ++j) {
            if (variables.get(j) instanceof ContinuousVariable) {
                this.continuousData[j] = new double[numRows];
                Arrays.fill(this.continuousData[j], Double.NaN);
                continue;
            }
            if (!(variables.get(j) instanceof DiscreteVariable)) continue;
            this.discreteData[j] = new int[numRows];
            Arrays.fill(this.discreteData[j], -99);
        }
    }

    public MixedDataBox(List<Node> variables, int numRows, double[][] continuousData, int[][] discreteData) {
        this.variables = variables;
        this.numRows = numRows;
        this.continuousData = continuousData;
        this.discreteData = discreteData;
        if (variables == null) {
            throw new IllegalArgumentException("Parameter variables cannot be null.");
        }
        if (numRows < 0) {
            throw new IllegalArgumentException("Parameter numRows cannot be negative.");
        }
        if (continuousData == null) {
            throw new IllegalArgumentException("Parameter continuousData cannot be null.");
        }
        if (discreteData == null) {
            throw new IllegalArgumentException("Parameter discreteData cannot be null.");
        }
        int numOfVars = variables.size();
        if (continuousData.length != numOfVars) {
            throw new IllegalArgumentException(String.format("Continuous Data: expect %d variables but found %d.", numOfVars, continuousData.length));
        }
        if (discreteData.length != numOfVars) {
            throw new IllegalArgumentException(String.format("Discrete Data: expect %d variables but found %d.", numOfVars, discreteData.length));
        }
        for (int i = 0; i < numOfVars; ++i) {
            if (continuousData[i] == null == (discreteData[i] == null)) {
                String errMsg = String.format("Variable at index %d either has data for both discrete and continuous or has no data for both.", i);
                throw new IllegalArgumentException(errMsg);
            }
            if (continuousData[i] != null && continuousData[i].length != numRows) {
                String errMsg = String.format("Continuous Data: Inconsistent row number at index %d.  Expect %d rows but found %d.", i, numRows, continuousData[i].length);
                throw new IllegalArgumentException(errMsg);
            }
            if (discreteData[i] == null || discreteData[i].length == numRows) continue;
            String errMsg = String.format("Discrete Data: Inconsistent row number at index %d.  Expect %d rows but found %d.", i, numRows, discreteData[i].length);
            throw new IllegalArgumentException(errMsg);
        }
    }

    public static BoxDataSet serializableInstance() {
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < 4; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        return new BoxDataSet(new ShortDataBox(4, 4), vars);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.variables.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(int row, int col, Number value) {
        if (value == null) {
            if (this.continuousData[col] != null) {
                this.continuousData[col][row] = Double.NaN;
                return;
            } else {
                if (this.discreteData[col] == null) throw new IllegalArgumentException("Indices out of bounds or null value.");
                this.discreteData[col][row] = -99;
            }
            return;
        } else if (this.continuousData[col] != null) {
            this.continuousData[col][row] = value.doubleValue();
            return;
        } else {
            if (this.discreteData[col] == null) throw new IllegalArgumentException("Indices out of bounds or null value.");
            this.discreteData[col][row] = value.intValue();
        }
    }

    @Override
    public Number get(int row, int col) {
        if (col >= this.continuousData.length || row >= this.numRows()) {
            return null;
        }
        if (this.continuousData[col] != null) {
            double v = this.continuousData[col][row];
            return Double.isNaN(v) ? null : Double.valueOf(v);
        }
        if (this.discreteData[col] != null) {
            double v = this.discreteData[col][row];
            return v == -99.0 ? null : Double.valueOf(v);
        }
        throw new IllegalArgumentException("Indices out of range.");
    }

    @Override
    public DataBox copy() {
        MixedDataBox box = new MixedDataBox(this.variables, this.numRows());
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numCols(); ++j) {
                box.set(i, j, this.get(i, j));
            }
        }
        return box;
    }

    @Override
    public DataBox like() {
        int[] rows = new int[this.numRows()];
        int[] cols = new int[this.numCols()];
        for (int i = 0; i < this.numRows(); ++i) {
            rows[i] = i;
        }
        for (int j = 0; j < this.numCols(); ++j) {
            cols[j] = j;
        }
        return this.viewSelection(rows, cols);
    }

    public void addVariable(Node variable) {
        this.variables.add(variable);
        this.continuousData = (double[][])Arrays.copyOf(this.continuousData, this.continuousData.length + 1);
        this.discreteData = (int[][])Arrays.copyOf(this.discreteData, this.discreteData.length + 1);
        if (variable instanceof ContinuousVariable) {
            this.continuousData[this.continuousData.length - 1] = new double[this.numRows];
        } else if (variable instanceof DiscreteVariable) {
            this.discreteData[this.discreteData.length - 1] = new int[this.numRows];
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public DataBox viewSelection(int[] rows, int[] cols) {
        ArrayList<Node> newVars = new ArrayList<Node>();
        for (int c : cols) {
            newVars.add(this.variables.get(c));
        }
        int row_num = rows.length;
        int col_num = cols.length;
        MixedDataBox _dataBox = new MixedDataBox(newVars, row_num);
        for (int i = 0; i < row_num; ++i) {
            for (int j = 0; j < col_num; ++j) {
                _dataBox.set(i, j, this.get(rows[i], cols[j]));
            }
        }
        return _dataBox;
    }

    public double[][] getContinuousData() {
        return this.continuousData;
    }

    public int[][] getDiscreteData() {
        return this.discreteData;
    }
}

