/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexTokenizer {
    private final CharSequence chars;
    private final Matcher delimiterMatcher;
    private final Matcher quoteCharMatcher;
    private int position;
    private final char quoteChar;
    private boolean finalTokenParsed;
    private boolean quoteSensitive = true;

    public RegexTokenizer(CharSequence line, Pattern delimiterPattern, char quoteChar) {
        this.chars = line;
        this.quoteChar = quoteChar;
        this.delimiterMatcher = delimiterPattern.matcher(line);
        this.quoteCharMatcher = Pattern.compile(Character.toString(quoteChar)).matcher(line);
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') continue;
            this.position = i;
            break;
        }
    }

    public boolean hasMoreTokens() {
        return !this.finalTokenParsed;
    }

    public String nextToken() {
        if (this.position != this.chars.length() && this.quoteSensitive && this.chars.charAt(this.position) == this.quoteChar) {
            boolean match = this.quoteCharMatcher.find(this.position + 1);
            int end = match ? this.quoteCharMatcher.end() : this.chars.length();
            CharSequence token = this.chars.subSequence(this.position + 1, end - 1);
            match = this.delimiterMatcher.find(end);
            this.position = end = match ? this.delimiterMatcher.end() : this.chars.length();
            if (!match) {
                this.finalTokenParsed = true;
            }
            return token.toString();
        }
        boolean match = this.delimiterMatcher.find(this.position);
        int start = match ? this.delimiterMatcher.start() : this.chars.length();
        int end = match ? this.delimiterMatcher.end() : this.chars.length();
        CharSequence token = this.chars.subSequence(this.position, start);
        this.position = end;
        if (!match) {
            this.finalTokenParsed = true;
        }
        return token.toString();
    }

    public void setQuoteSensitive(boolean quoteSensitive) {
        this.quoteSensitive = quoteSensitive;
    }
}

