/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class TimeSeriesData
implements DataModel {
    static final long serialVersionUID = 23L;
    private final Matrix data2;
    private String name;
    private final List<String> varNames;
    private Knowledge knowledge = new Knowledge();

    public TimeSeriesData(Matrix matrix, List<String> varNames) {
        if (matrix == null) {
            throw new NullPointerException("Data must not be null.");
        }
        if (varNames == null) {
            throw new NullPointerException("Variables must not be null.");
        }
        for (int i = 0; i < varNames.size(); ++i) {
            if (varNames.get(i) != null) continue;
            throw new NullPointerException("Variable at index " + i + "is null.");
        }
        this.data2 = matrix;
        if (varNames.size() != matrix.columns()) {
            throw new IllegalArgumentException("Number of columns in the data must match the number of variables.");
        }
        this.varNames = varNames;
        this.name = "Time Series Data";
    }

    public static TimeSeriesData serializableInstance() {
        ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("X");
        varNames.add("Y");
        return new TimeSeriesData(new Matrix(2, 2), varNames);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        this.name = name;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    @Override
    public boolean isMixed() {
        return false;
    }

    @Override
    public Node getVariable(String name) {
        return null;
    }

    @Override
    public DataModel copy() {
        return null;
    }

    @Override
    public List<Node> getVariables() {
        List<String> varNames = this.getVariableNames();
        LinkedList<Node> vars = new LinkedList<Node>();
        for (String varName : varNames) {
            vars.add(new ContinuousVariable(varName));
        }
        return vars;
    }

    @Override
    public Knowledge getKnowledge() {
        System.out.println();
        return this.knowledge.copy();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge.copy();
    }

    @Override
    public List<String> getVariableNames() {
        return this.varNames;
    }

    public Matrix getData() {
        return this.data2.copy();
    }

    public int getNumTimePoints() {
        return this.getData().rows();
    }

    public int getNumVars() {
        return this.getVariableNames().size();
    }

    public double getDatum(int row, int col) {
        return this.data2.get(row, col);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.name == null) {
            throw new NullPointerException();
        }
        if (this.varNames == null) {
            throw new NullPointerException();
        }
        if (this.knowledge == null) {
            throw new NullPointerException();
        }
    }
}

