/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.ShortDataBox;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;

public class VerticalDoubleDataBox
implements DataBox {
    static final long serialVersionUID = 23L;
    private final double[][] data;
    private final int numRows;
    private final int numCols;

    public VerticalDoubleDataBox(int rows, int cols) {
        this.data = new double[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data[j][i] = Double.NaN;
            }
        }
        this.numRows = rows;
        this.numCols = cols;
    }

    public VerticalDoubleDataBox(double[][] data) {
        int length = data[0].length;
        for (double[] datum : data) {
            if (datum.length == length) continue;
            throw new IllegalArgumentException("All columns must have same length.");
        }
        this.data = data;
        this.numRows = data[0].length;
        this.numCols = data.length;
    }

    public VerticalDoubleDataBox(DataBox dataBox) {
        this.data = new double[dataBox.numCols()][dataBox.numRows()];
        for (int i = 0; i < dataBox.numRows(); ++i) {
            for (int j = 0; j < dataBox.numCols(); ++j) {
                this.data[j][i] = dataBox.get(i, j).doubleValue();
            }
        }
        this.numRows = dataBox.numRows();
        this.numCols = dataBox.numCols();
    }

    public static BoxDataSet serializableInstance() {
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < 4; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        return new BoxDataSet(new ShortDataBox(4, 4), vars);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int row, int col, Number value) {
        if (value == null) {
            double[] dArray = this.data[col];
            synchronized (dArray) {
                this.data[col][row] = Double.NaN;
            }
        }
        double[] dArray = this.data[col];
        synchronized (dArray) {
            this.data[col][row] = value.doubleValue();
        }
    }

    @Override
    public Number get(int row, int col) {
        return this.data[col][row];
    }

    public double[][] getVariableVectors() {
        if (this.numCols == 0 || this.numRows == 0) {
            return new double[0][0];
        }
        return this.data;
    }

    @Override
    public DataBox copy() {
        double[][] copy = new double[this.data.length][this.data[0].length];
        for (int i = 0; i < this.data.length; ++i) {
            System.arraycopy(this.data[i], 0, copy[i], 0, this.data[0].length);
        }
        return new VerticalDoubleDataBox(copy);
    }

    @Override
    public DataBox like() {
        int[] rows = new int[this.numRows()];
        int[] cols = new int[this.numCols()];
        for (int i = 0; i < this.numRows(); ++i) {
            rows[i] = i;
        }
        for (int j = 0; j < this.numCols(); ++j) {
            cols[j] = j;
        }
        return this.viewSelection(rows, cols);
    }

    @Override
    public DataBox viewSelection(int[] rows, int[] cols) {
        VerticalDoubleDataBox _dataBox = new VerticalDoubleDataBox(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                _dataBox.set(i, j, this.get(rows[i], cols[j]));
            }
        }
        return _dataBox;
    }
}

