/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.akutsu;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.akutsu.RevealOutputGraph;

public class BoolSearch {
    private final int[][] cases;
    private final int ngenes;
    private final int ntimes;
    String[] names;

    public BoolSearch(int[][] cases, String[] names) {
        this.cases = cases;
        this.names = names;
        this.ntimes = cases.length;
        this.ngenes = cases[0].length;
    }

    public RevealOutputGraph bool2(int k) {
        double theta0;
        int[][] parents = new int[this.ngenes][];
        int[][] lags = new int[this.ngenes][];
        int[] f = new int[this.ngenes];
        int numberTotalInputs = 1;
        for (int i = 0; i < this.ngenes; ++i) {
            numberTotalInputs *= 2;
        }
        int numberInputCombinations = 1;
        for (int i = 0; i < k; ++i) {
            numberInputCombinations *= 2;
        }
        double theta = theta0 = 1.0 / (2.0 * (double)numberInputCombinations * (double)numberInputCombinations);
        System.out.println("Theta = " + theta);
        int numberBooleanFunctions = 1;
        for (int i = 0; i < numberInputCombinations; ++i) {
            numberBooleanFunctions *= 2;
        }
        System.out.println("nrows = " + numberInputCombinations + " number functions = " + numberBooleanFunctions);
        for (int gchild = 0; gchild < this.ngenes; ++gchild) {
            System.out.println("Child gene " + gchild);
            block4: for (int m = 1; m <= 20; ++m) {
                theta = theta0 * (double)m;
                System.out.println("Theta = " + theta);
                int count = 0;
                int[] pars = new int[k];
                pars[0] = -1;
                pars[1] = -1;
                pars[2] = -1;
                for (int input = 0; input < numberTotalInputs; ++input) {
                    byte[] inputs = this.booleanRepresentation(input, this.ngenes);
                    if (this.sumBits(inputs) != k) continue;
                    int j = 0;
                    for (int i = 0; i < this.ngenes; ++i) {
                        if (inputs[i] != 1) continue;
                        pars[j] = i;
                        ++j;
                    }
                    for (int function = 0; function < numberBooleanFunctions; ++function) {
                        byte[] fi = this.booleanRepresentation(function, numberInputCombinations);
                        int mismatch = 0;
                        for (int j2 = 0; j2 < this.ntimes - 1; ++j2) {
                            int argument = 0;
                            int power = 1;
                            for (int i = 0; i < k; ++i) {
                                argument += power * this.cases[j2][pars[k - i - 1]];
                                power *= 2;
                            }
                            byte finput = fi[argument];
                            if (finput == this.cases[j2 + 1][gchild]) continue;
                            ++mismatch;
                        }
                        if (!((double)mismatch < theta * (double)this.ntimes)) continue;
                        System.out.println("update parents");
                        parents[gchild] = new int[k];
                        lags[gchild] = new int[k];
                        f[gchild] = function;
                        for (int i = 0; i < k; ++i) {
                            parents[gchild][i] = pars[i];
                            lags[gchild][i] = 1;
                        }
                        count = 1;
                        break block4;
                    }
                }
                if (count != 1) {
                    System.out.println("Regulators not identified count = " + count);
                    parents[gchild] = new int[0];
                    lags[gchild] = new int[0];
                    continue;
                }
                System.out.println("Regulators are:  ");
                for (int i = 0; i < parents[gchild].length; ++i) {
                    System.out.println("  i = " + i + " par = " + parents[gchild][i]);
                }
            }
            System.out.println("regulators are:  ");
            for (int i = 0; i < parents[gchild].length; ++i) {
                System.out.println("  i = " + i + " par = " + parents[gchild][i]);
            }
        }
        System.out.println("Returning");
        return null;
    }

    public byte[] booleanRepresentation(int ind, int n) {
        int i;
        byte[] rep = new byte[n];
        for (i = 0; i < n; ++i) {
            rep[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            int rem = ind % 2;
            if (rem == 1) {
                rep[n - i - 1] = 1;
                --ind;
            }
            ind /= 2;
        }
        return rep;
    }

    public int sumBits(byte[] b) {
        int sum = 0;
        for (byte aB : b) {
            sum += aB;
        }
        return sum;
    }
}

