/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.biolingua;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.util.BasicGraph;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.util.MatrixF;
import java.io.IOException;

public class Digraph
extends BasicGraph {
    private MatrixF edges;
    private int[] nParents;

    public Digraph(String gName, int nNodes) {
        super(gName, nNodes);
    }

    public Digraph(String fname) throws IOException {
        super(fname);
    }

    public Digraph(Digraph digraph) {
        this("Clone_of_[" + digraph + "]", digraph.nNodes);
        for (int i = 0; i < digraph.nNodes; ++i) {
            this.nodeNames[i] = digraph.nodeNames[i];
            for (int j = 0; j < i; ++j) {
                this.setEdge(i, j, digraph.getEdge(i, j));
            }
        }
    }

    @Override
    public Object clone() {
        Digraph g2 = new Digraph("Clone_of_[" + this.graphName + "]", this.nNodes);
        for (int i = 0; i < this.nNodes; ++i) {
            g2.nodeNames[i] = this.nodeNames[i];
            for (int j = 0; j < i; ++j) {
                g2.setEdge(i, j, this.getEdge(i, j));
            }
        }
        return g2;
    }

    @Override
    protected void initializeEdges() {
        this.edges = new MatrixF("EdgeMatrix_" + this.graphName, this.nNodes);
        this.nParents = new int[this.nNodes];
    }

    @Override
    public void setEdge(int i, int j, double value) {
        double e = this.getEdges().getDoubleValue(i, j);
        this.getEdges().setDoubleValue(i, j, value);
        if (e == 0.0 && value != 0.0) {
            ++this.nEdges;
            int n = j;
            this.nParents[n] = this.nParents[n] + 1;
        } else if (e != 0.0 && value == 0.0) {
            --this.nEdges;
            int n = j;
            this.nParents[n] = this.nParents[n] - 1;
        }
    }

    @Override
    public double getEdge(int i, int j) {
        return this.getEdges().getDoubleValue(i, j);
    }

    @Override
    public String EdgesToString() {
        String s = "";
        int ne = 0;
        for (int i = 0; i < this.nNodes; ++i) {
            for (int j = 0; j < this.nNodes; ++j) {
                double e = this.getEdges().getDoubleValue(i, j);
                if (e == 0.0) continue;
                s = s + i + "  " + j + " \t" + e + "\n";
                ++ne;
            }
        }
        return s;
    }

    public int getNumParents(int i) {
        if (i < 0 || i >= this.getSize()) {
            this.badNodeIndex(i);
        }
        return this.nParents[i];
    }

    public int[] getParents(int j) {
        if (j < 0 || j >= this.nNodes) {
            this.badNodeIndex(j);
        }
        int[] ap = new int[this.nParents[j]];
        int np = 0;
        for (int i = 0; i < this.nNodes; ++i) {
            if (this.getEdges().getDoubleValue(i, j) == 0.0) continue;
            ap[np] = i;
            ++np;
        }
        return ap;
    }

    public MatrixF getEdges() {
        return this.edges;
    }
}

