/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.ideker;

import edu.cmu.tetrad.util.NumberFormatUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class ReadControl {
    public static void main(String[] argv) {
        int g;
        int n;
        int j;
        FileInputStream s;
        String fileName = argv[0];
        int ngenes = 9;
        int nperturbations = 20;
        int readingsPerPerturbation = 4;
        int nrecords = 7;
        int[][] rawData = new int[9][80];
        int[] nvaluesRecord = new int[]{10, 12, 12, 12, 12, 12, 10};
        int[] offSet = new int[]{0, 10, 22, 34, 46, 58, 70};
        String[] name = new String[9];
        String[] code = new String[9];
        double[][] expressions = new double[20][9];
        double[] meanExpression = new double[9];
        try {
            s = new FileInputStream(fileName);
        }
        catch (IOException e) {
            System.out.println("Cannot open file " + fileName);
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(s));
        for (int k = 0; k < 7; ++k) {
            for (j = 0; j < 10; ++j) {
                try {
                    int i;
                    StringTokenizer st = new StringTokenizer(in.readLine());
                    if (j == 0) continue;
                    if (k == 0) {
                        code[j - 1] = st.nextToken(" ");
                        name[j - 1] = st.nextToken(" ");
                        for (i = 0; i < nvaluesRecord[k]; ++i) {
                            rawData[j - 1][i + offSet[k]] = Integer.parseInt(st.nextToken(" "));
                        }
                        continue;
                    }
                    for (i = 0; i < nvaluesRecord[k]; ++i) {
                        rawData[j - 1][i + offSet[k]] = Integer.parseInt(st.nextToken(" "));
                    }
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Read error in " + fileName);
                    return;
                }
            }
        }
        for (int i = 10; i < 20; ++i) {
            for (j = 0; j < 9; ++j) {
                double sum = 0.0;
                n = 0;
                for (int k = 0; k < 4; ++k) {
                    if (rawData[j][i * 4 + k] <= -900) continue;
                    ++n;
                    sum += (double)rawData[j][i * 4 + k];
                }
                expressions[i][j] = sum / (double)n;
            }
        }
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        for (int p = 10; p < 20; ++p) {
            for (int g2 = 0; g2 < 5; ++g2) {
                String exp = nf.format(expressions[p][g2]);
                System.out.print(exp + "  ");
            }
            System.out.println();
        }
        for (g = 0; g < 9; ++g) {
            double sum = 0.0;
            n = 0;
            for (int p = 10; p < 20; ++p) {
                sum += expressions[p][g];
                ++n;
            }
            meanExpression[g] = sum / (double)n;
        }
        System.out.println("Mean expression for each gene");
        for (g = 0; g < 9; ++g) {
            String mean = nf.format(meanExpression[g]);
            System.out.print(mean + " ");
        }
        System.out.println();
    }
}

