/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.ideker;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.ideker.ItkPredictorSearch;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class ReadIdeker {
    public static void main(String[] argv) {
        int g;
        int p;
        int j;
        FileInputStream s;
        String fileName = argv[0];
        int ngenes = 9;
        int nperturbations = 20;
        int readingsPerPerturbation = 4;
        int nrecords = 7;
        int[][] rawData = new int[9][80];
        int[] nvaluesRecord = new int[]{10, 13, 12, 13, 13, 14, 5};
        int[] offSet = new int[]{0, 10, 23, 35, 48, 61, 75};
        String[] name = new String[9];
        String[] code = new String[9];
        double[][] expressions = new double[20][9];
        int[][] binaryExpression = new int[10][9];
        double[] meanExpression = new double[]{32514.058, 26663.615, 7421.692, 176.9, 10602.458, 5491.0, 28358.983, 13640.675, 3877.975};
        try {
            s = new FileInputStream(fileName);
        }
        catch (IOException e) {
            System.out.println("Cannot open file " + fileName);
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(s));
        for (int k = 0; k < 7; ++k) {
            for (j = 0; j < 10; ++j) {
                try {
                    int i;
                    StringTokenizer st = new StringTokenizer(in.readLine());
                    if (j == 0) continue;
                    if (k == 0) {
                        code[j - 1] = st.nextToken(" ");
                        name[j - 1] = st.nextToken(" ");
                        for (i = 0; i < nvaluesRecord[k]; ++i) {
                            rawData[j - 1][i + offSet[k]] = Integer.parseInt(st.nextToken(" "));
                        }
                        continue;
                    }
                    for (i = 0; i < nvaluesRecord[k]; ++i) {
                        rawData[j - 1][i + offSet[k]] = Integer.parseInt(st.nextToken(" "));
                    }
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Read error in " + fileName);
                    return;
                }
            }
        }
        for (int i = 0; i < 20; ++i) {
            for (j = 0; j < 9; ++j) {
                double sum = 0.0;
                int n = 0;
                for (int k = 0; k < 4; ++k) {
                    if (rawData[j][i * 4 + k] <= -900) continue;
                    ++n;
                    sum += (double)rawData[j][i * 4 + k];
                }
                expressions[i][j] = sum / (double)n;
            }
        }
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        for (p = 0; p < 20; ++p) {
            for (int g2 = 0; g2 < 5; ++g2) {
                String exp = nf.format(expressions[p][g2]);
                System.out.print(exp + "  ");
            }
            System.out.println();
        }
        System.out.println("Mean expression for each gene");
        for (g = 0; g < 9; ++g) {
            String mean = nf.format(meanExpression[g]);
            System.out.print(mean + " ");
        }
        System.out.println();
        for (g = 0; g < 9; ++g) {
            for (int p2 = 0; p2 < 10; ++p2) {
                binaryExpression[p2][g] = p2 - 1 == g ? -1 : (expressions[p2][g] > meanExpression[g] ? 1 : 0);
            }
        }
        for (p = 0; p < 10; ++p) {
            for (int g3 = 0; g3 < 9; ++g3) {
                System.out.print(binaryExpression[p][g3] + "\t");
            }
            System.out.println();
        }
        ItkPredictorSearch ips = new ItkPredictorSearch(9, binaryExpression, name);
        for (int gene = 0; gene < 9; ++gene) {
            ips.predictor(gene);
        }
    }
}

