/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbComponent;
import edu.cmu.tetrad.util.NamingProtocol;

public abstract class AbstractNbComponent
implements NbComponent {
    private NbComponent[] parents;
    private int[] inhibitExcite;
    private int nparents;
    private double value;
    private String name;
    private double factor;
    private double power;
    private double sd;

    public AbstractNbComponent(double factor, double power, NbComponent[] parents, int[] inhibitExcite, String name) {
        this.setFactor(factor);
        this.setPower(power);
        this.setParents(parents);
        this.setInhibitExcite(inhibitExcite);
        this.setName(name);
        if (parents == null) {
            this.setNparents(0);
        } else {
            this.setNparents(parents.length);
        }
        this.setValue(0.0);
        this.setSd(0.1);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setValue(double level) {
        this.value = level;
    }

    @Override
    public void addParent(NbComponent component, int ie) {
        if (this.getParents() == null) {
            this.setParents(new NbComponent[1]);
            this.getParents()[0] = component;
            this.setInhibitExcite(new int[1]);
            this.getInhibitExcite()[0] = ie;
            this.setNparents(1);
        } else {
            NbComponent[] newParents = new NbComponent[this.getParents().length + 1];
            int[] newInhibitExcite = new int[this.getParents().length + 1];
            newParents[this.getParents().length] = component;
            newInhibitExcite[this.getParents().length] = ie;
            for (int i = 0; i < this.getParents().length; ++i) {
                newParents[i] = this.getParents()[i];
                newInhibitExcite[i] = this.getInhibitExcite()[i];
            }
            this.setParents(newParents);
            this.setInhibitExcite(newInhibitExcite);
            this.setNparents(this.getNparents() + 1);
        }
    }

    public void displayParents() {
        for (int i = 0; i < this.getNparents(); ++i) {
            System.out.println(this.getParents()[i].getName() + " " + this.getParents()[i].getValue() + " " + this.getInhibitExcite()[i]);
        }
    }

    @Override
    public abstract void update();

    public NbComponent[] getParents() {
        return this.parents;
    }

    public void setParents(NbComponent[] parents) {
        this.parents = parents;
    }

    public int[] getInhibitExcite() {
        return this.inhibitExcite;
    }

    public void setInhibitExcite(int[] inhibitExcite) {
        this.inhibitExcite = inhibitExcite;
    }

    public int getNparents() {
        return this.nparents;
    }

    public void setNparents(int nparents) {
        this.nparents = nparents;
    }

    public void setName(String name) {
        if (!NamingProtocol.isLegalName(name)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.name = name;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public double getSd() {
        return this.sd;
    }

    public void setSd(double sd) {
        this.sd = sd;
    }
}

