/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.commons.math3.util.FastMath;

public class LTestReveal {
    static int ngenes = 6;
    static int ntimes = 400;
    static int[][] cases = new int[ntimes][ngenes];

    public static void main(String[] argv) {
        int j;
        int k;
        FileInputStream s;
        String fileName = argv[0];
        try {
            s = new FileInputStream(fileName);
        }
        catch (IOException e) {
            System.out.println("Cannot open file " + fileName);
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(s));
        for (k = 0; k < ntimes; ++k) {
            try {
                StringTokenizer st = new StringTokenizer(in.readLine());
                for (j = 0; j < ngenes; ++j) {
                    LTestReveal.cases[k][j] = Integer.parseInt(st.nextToken("\t"));
                }
                continue;
            }
            catch (IOException e) {
                System.out.println("Read error in " + fileName);
                return;
            }
        }
        System.out.println("case 0 " + cases[0][0] + " " + cases[0][1] + " " + cases[0][2] + " " + cases[0][3] + " " + cases[0][4]);
        for (k = 0; k < ntimes; ++k) {
            for (j = 0; j < ngenes; ++j) {
                if (cases[k][j] != -1) continue;
                LTestReveal.cases[k][j] = 0;
            }
        }
        boolean lag = true;
        int[] p = new int[1];
        for (int child = 0; child < ngenes; ++child) {
            System.out.println("For gene " + child);
            for (int i = 0; i < ngenes; ++i) {
                p[0] = i;
                double m = LTestReveal.mutualInformation(child, p, 1);
                System.out.println("for parent = " + i + " m = " + m);
            }
        }
        int[] pp = new int[2];
        for (int child = 0; child < ngenes; ++child) {
            System.out.println("For gene " + child);
            for (int p1 = 0; p1 < ngenes; ++p1) {
                for (int p2 = 0; p2 < ngenes && p1 != p2; ++p2) {
                    pp[0] = p1;
                    pp[1] = p2;
                    double mm = LTestReveal.mutualInformation(child, pp, 1);
                    System.out.println("for parents = " + p1 + "," + p2 + " m = " + mm);
                }
            }
        }
        int[] ppp = new int[3];
        for (int child = 0; child < ngenes; ++child) {
            System.out.println("For gene " + child);
            for (int p1 = 0; p1 < ngenes; ++p1) {
                for (int p2 = 0; p2 < ngenes && p2 != p1; ++p2) {
                    for (int p3 = 0; p3 < ngenes && p3 != p2 && p3 != p1; ++p3) {
                        ppp[0] = p1;
                        ppp[1] = p2;
                        ppp[2] = p3;
                        double mmm = LTestReveal.mutualInformation(child, ppp, 1);
                        System.out.println("for parents = " + p1 + "," + p2 + "," + p3 + " m = " + mmm);
                    }
                }
            }
        }
    }

    public static double mutualInformation(int child, int[] parents, int lag) {
        int i;
        double M = 0.0;
        int[] c = new int[ntimes - lag];
        for (int i2 = lag; i2 < ntimes; ++i2) {
            c[i2 - lag] = cases[i2][child];
        }
        double hchild = LTestReveal.entropy(child, lag);
        int[] p1 = new int[ntimes - lag];
        int[][] pm = new int[parents.length][ntimes - lag];
        double hparents = 0.0;
        for (i = 0; i < ntimes - lag; ++i) {
            p1[i] = cases[i][parents[0]];
        }
        hparents = LTestReveal.entropy(p1);
        if (parents.length > 1) {
            for (i = 0; i < ntimes - lag; ++i) {
                for (int j = 1; j < parents.length; ++j) {
                    pm[j - 1][i] = cases[i][parents[j]];
                }
            }
            hparents = LTestReveal.jointEntropy(p1, pm);
        }
        double hjoint = 0.0;
        if (parents.length == 1) {
            hjoint = LTestReveal.jointEntropy(c, p1);
        } else {
            int[][] p1pm = new int[parents.length][ntimes - lag];
            for (int i3 = 0; i3 < ntimes - lag; ++i3) {
                p1pm[0][i3] = p1[i3];
                for (int j = 0; j < parents.length - 1; ++j) {
                    p1pm[j + 1][i3] = pm[j][i3];
                }
            }
            hjoint = LTestReveal.jointEntropy(c, p1pm);
        }
        M = hchild + hparents - hjoint;
        return M;
    }

    public static double entropy(int[] x) {
        double h = 0.0;
        int n = x.length;
        double ln2 = FastMath.log(2.0);
        int n0 = 0;
        for (int j : x) {
            if (j != 0) continue;
            ++n0;
        }
        if (n0 == 0 || n0 == n) {
            return h;
        }
        double p = (double)n0 / (double)n;
        h = -(p * FastMath.log(p) + (1.0 - p) * FastMath.log(1.0 - p)) / ln2;
        return h;
    }

    public static double entropy(int g, int lag) {
        double h = 0.0;
        int n = cases.length - lag;
        double ln2 = FastMath.log(2.0);
        int n0 = 0;
        for (int i = 0; i < n; ++i) {
            if (cases[i + lag][g] != 0) continue;
            ++n0;
        }
        if (n0 == 0 || n0 == n) {
            return h;
        }
        double p = (double)n0 / (double)n;
        h = -(p * FastMath.log(p) + (1.0 - p) * FastMath.log(1.0 - p)) / ln2;
        return h;
    }

    public static double jointEntropy(int[] x, int[] y) {
        double h = 0.0;
        int[][] ns = new int[2][2];
        int n = x.length;
        double ln2 = FastMath.log(2.0);
        ns[0][0] = 0;
        ns[0][1] = 0;
        ns[1][0] = 0;
        ns[1][1] = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int[] nArray = ns[x[i]];
                int n2 = y[i];
                nArray[n2] = nArray[n2] + 1;
            }
        }
        int ntot = ns[0][0] + ns[0][1] + ns[1][0] + ns[1][1];
        double[][] p = new double[2][2];
        p[0][0] = (double)ns[0][0] / (double)ntot;
        p[0][1] = (double)ns[0][1] / (double)ntot;
        p[1][0] = (double)ns[1][0] / (double)ntot;
        p[1][1] = (double)ns[1][1] / (double)ntot;
        double lp00 = p[0][0] == 0.0 ? 0.0 : -p[0][0] * FastMath.log(p[0][0]);
        double lp01 = p[0][1] == 0.0 ? 0.0 : -p[0][1] * FastMath.log(p[0][1]);
        double lp10 = p[1][0] == 0.0 ? 0.0 : -p[1][0] * FastMath.log(p[1][0]);
        double lp11 = p[1][1] == 0.0 ? 0.0 : -p[1][1] * FastMath.log(p[1][1]);
        h = lp00 + lp01 + lp10 + lp11;
        return h /= ln2;
    }

    public static double jointEntropy(int[] x, int[][] y) {
        double h = 0.0;
        int m = y.length;
        int n = x.length;
        double ln2 = FastMath.log(2.0);
        if (y[0].length != n) {
            System.out.println("x and rows of y and must have same length");
            System.exit(0);
        }
        int nyconfigs = 1;
        for (int j = 0; j < m; ++j) {
            nyconfigs *= 2;
        }
        int nconfigs = 2 * nyconfigs;
        int[] counts = new int[nconfigs];
        for (int i = 0; i < nconfigs; ++i) {
            counts[i] = 0;
        }
        int config = 0;
        int ntot = 0;
        for (int i = 0; i < n; ++i) {
            int power = 1;
            config = x[i] * power;
            for (int[] ints : y) {
                config += ints[i] * (power *= 2);
            }
            int n2 = config;
            counts[n2] = counts[n2] + 1;
            ++ntot;
        }
        for (int i = 0; i < nconfigs; ++i) {
            double p = (double)counts[i] / (double)ntot;
            if (p == 0.0) continue;
            h -= p * FastMath.log(p);
        }
        return h /= ln2;
    }

    public byte[] booleanRepresentation(int ind, int n) {
        int i;
        byte[] rep = new byte[n];
        for (i = 0; i < n; ++i) {
            rep[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            int rem = ind % 2;
            if (rem == 1) {
                rep[n - i - 1] = 1;
                --ind;
            }
            ind /= 2;
        }
        return rep;
    }
}

