/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin;

import org.apache.commons.math3.util.FastMath;

public class RevealEvaluator {
    private int ngenes;
    private int ntimes;
    private int[][] cases;

    public RevealEvaluator(int[][] cases) {
        this.cases = new int[this.ntimes][this.ngenes];
        this.ntimes = cases.length;
        this.ngenes = cases[0].length;
        this.cases = cases;
    }

    public int[][] crossTab(int child, int parent, int lag) {
        int[][] ns = new int[2][2];
        ns[0][0] = 0;
        ns[0][1] = 0;
        ns[1][0] = 0;
        ns[1][1] = 0;
        for (int i = lag; i < this.ntimes; ++i) {
            int j = i - lag;
            int[] nArray = ns[this.cases[i][child]];
            int n = this.cases[j][parent];
            nArray[n] = nArray[n] + 1;
        }
        return ns;
    }

    public double mutualInformation(int child, int[] parents, int lag) {
        double hjoint;
        int i;
        int[] c = new int[this.ntimes - lag];
        for (int i2 = lag; i2 < this.ntimes; ++i2) {
            c[i2 - lag] = this.cases[i2][child];
        }
        double hchild = this.entropy(c);
        int[] p1 = new int[this.ntimes - lag];
        int[][] pm = new int[parents.length][this.ntimes - lag];
        for (i = 0; i < this.ntimes - lag; ++i) {
            p1[i] = this.cases[i][parents[0]];
        }
        double hparents = this.entropy(p1);
        if (parents.length > 1) {
            for (i = 0; i < this.ntimes - lag; ++i) {
                for (int j = 1; j < parents.length; ++j) {
                    pm[j - 1][i] = this.cases[i][parents[j]];
                }
            }
            hparents = this.jointEntropy(p1, pm);
        }
        if (parents.length == 1) {
            hjoint = this.jointEntropy(c, p1);
        } else {
            int[][] p1pm = new int[parents.length][this.ntimes - lag];
            for (int i3 = 0; i3 < this.ntimes - lag; ++i3) {
                p1pm[0][i3] = p1[i3];
                for (int j = 0; j < parents.length - 1; ++j) {
                    p1pm[j + 1][i3] = pm[j][i3];
                }
            }
            hjoint = this.jointEntropy(c, p1pm);
        }
        double M = hchild + hparents - hjoint;
        return M;
    }

    public double mutualInformation(int child, int[] parents, int[] lags) {
        double hjoint;
        int i;
        int maxlag = 0;
        for (int lag : lags) {
            if (lag <= maxlag) continue;
            maxlag = lag;
        }
        int[] c = new int[this.ntimes - maxlag];
        for (int i2 = maxlag; i2 < this.ntimes; ++i2) {
            c[i2 - maxlag] = this.cases[i2][child];
        }
        double hchild = this.entropy(c);
        int[] p1 = new int[this.ntimes - maxlag];
        int[][] pm = new int[parents.length][this.ntimes - maxlag];
        for (i = 0; i < this.ntimes - maxlag; ++i) {
            p1[i] = this.cases[maxlag - lags[0] + i][parents[0]];
        }
        double hparents = this.entropy(p1);
        if (parents.length > 1) {
            for (i = 0; i < this.ntimes - maxlag; ++i) {
                for (int j = 1; j < parents.length; ++j) {
                    pm[j - 1][i] = this.cases[maxlag - lags[j] + i][parents[j]];
                }
            }
            hparents = this.jointEntropy(p1, pm);
        }
        if (parents.length == 1) {
            hjoint = this.jointEntropy(c, p1);
        } else {
            int[][] p1pm = new int[parents.length][this.ntimes - maxlag];
            for (int i3 = 0; i3 < this.ntimes - maxlag; ++i3) {
                p1pm[0][i3] = p1[i3];
                for (int j = 0; j < parents.length - 1; ++j) {
                    p1pm[j + 1][i3] = pm[j][i3];
                }
            }
            hjoint = this.jointEntropy(c, p1pm);
        }
        double M = hchild + hparents - hjoint;
        return M;
    }

    public double entropy(int[] x) {
        double h = 0.0;
        int n = x.length;
        double ln2 = FastMath.log(2.0);
        int n0 = 0;
        for (int j : x) {
            if (j != 0) continue;
            ++n0;
        }
        if (n0 == 0 || n0 == n) {
            return h;
        }
        double p = (double)n0 / (double)n;
        h = -(p * FastMath.log(p) + (1.0 - p) * FastMath.log(1.0 - p)) / ln2;
        return h;
    }

    public double entropy(int g, int lag) {
        double h = 0.0;
        int n = this.cases.length - lag;
        double ln2 = FastMath.log(2.0);
        int n0 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.cases[i + lag][g] != 0) continue;
            ++n0;
        }
        if (n0 == 0 || n0 == n) {
            return h;
        }
        double p = (double)n0 / (double)n;
        h = -(p * FastMath.log(p) + (1.0 - p) * FastMath.log(1.0 - p)) / ln2;
        return h;
    }

    public double jointEntropy(int[] x, int[] y) {
        int[][] ns = new int[2][2];
        int n = x.length;
        double ln2 = FastMath.log(2.0);
        ns[0][0] = 0;
        ns[0][1] = 0;
        ns[1][0] = 0;
        ns[1][1] = 0;
        for (int i = 0; i < n; ++i) {
            int[] nArray = ns[x[i]];
            int n2 = y[i];
            nArray[n2] = nArray[n2] + 1;
        }
        double[][] p = new double[2][2];
        p[0][0] = (double)ns[0][0] / (double)n;
        p[0][1] = (double)ns[0][1] / (double)n;
        p[1][0] = (double)ns[1][0] / (double)n;
        p[1][1] = (double)ns[1][1] / (double)n;
        double lp00 = p[0][0] == 0.0 ? 0.0 : -p[0][0] * FastMath.log(p[0][0]);
        double lp01 = p[0][1] == 0.0 ? 0.0 : -p[0][1] * FastMath.log(p[0][1]);
        double lp10 = p[1][0] == 0.0 ? 0.0 : -p[1][0] * FastMath.log(p[1][0]);
        double lp11 = p[1][1] == 0.0 ? 0.0 : -p[1][1] * FastMath.log(p[1][1]);
        double h = lp00 + lp01 + lp10 + lp11;
        return h /= ln2;
    }

    public double jointEntropy(int[] x, int[][] y) {
        double h = 0.0;
        int m = y.length;
        int n = x.length;
        double ln2 = FastMath.log(2.0);
        if (y[0].length != n) {
            System.out.println("x and rows of y and must have same length");
            System.exit(0);
        }
        int nyconfigs = 1;
        for (int j = 0; j < m; ++j) {
            nyconfigs *= 2;
        }
        int nconfigs = 2 * nyconfigs;
        int[] counts = new int[nconfigs];
        for (int i = 0; i < nconfigs; ++i) {
            counts[i] = 0;
        }
        int ntot = 0;
        for (int i = 0; i < n; ++i) {
            int power = 1;
            int config = x[i] * power;
            for (int[] ints : y) {
                config += ints[i] * (power *= 2);
            }
            int n2 = config;
            counts[n2] = counts[n2] + 1;
            ++ntot;
        }
        for (int i = 0; i < nconfigs; ++i) {
            double p = (double)counts[i] / (double)ntot;
            if (p == 0.0) continue;
            h -= p * FastMath.log(p);
        }
        return h /= ln2;
    }

    public byte[] booleanRepresentation(int ind, int n) {
        int i;
        byte[] rep = new byte[n];
        for (i = 0; i < n; ++i) {
            rep[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            int rem = ind % 2;
            if (rem == 1) {
                rep[n - i - 1] = 1;
                --ind;
            }
            ind /= 2;
        }
        return rep;
    }
}

