/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.RevealEvaluator;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.RevealOutputGraph;

public class RevealSearch {
    private final int ngenes;
    String[] names;
    RevealEvaluator re;

    public RevealSearch(int[][] cases, String[] names) {
        this.names = names;
        int ntimes = cases.length;
        this.ngenes = cases[0].length;
        this.re = new RevealEvaluator(cases);
    }

    public RevealOutputGraph exhaustiveSearch(int lag) {
        double[] entropies = new double[this.ngenes];
        for (int g = 0; g < this.ngenes; ++g) {
            entropies[g] = this.re.entropy(g, lag);
        }
        int[][] ct = null;
        for (int child = 0; child < this.ngenes; ++child) {
            System.out.println("Crosstabs of gene " + child);
            for (int parent = 0; parent < this.ngenes; ++parent) {
                if (parent == child) continue;
                ct = this.re.crossTab(child, parent, lag);
                System.out.println("with parent " + parent + " at lag " + lag);
                System.out.println("  " + ct[0][0] + " " + ct[0][1]);
                System.out.println("  " + ct[1][0] + " " + ct[1][1]);
            }
        }
        int[][] parents = new int[this.ngenes][];
        double[] best1 = new double[this.ngenes];
        double[] best2 = new double[this.ngenes];
        double[] best3 = new double[this.ngenes];
        int[] p = new int[1];
        for (int child = 0; child < this.ngenes; ++child) {
            System.out.println("For gene " + child);
            best1[child] = -1.0;
            for (int i = 0; i < this.ngenes; ++i) {
                p[0] = i;
                double m = this.re.mutualInformation(child, p, lag);
                double me = m / entropies[child];
                if (me > best1[child]) {
                    best1[child] = me;
                    parents[child] = new int[1];
                    parents[child][0] = i;
                }
                System.out.println("for parent = " + i + " m = " + m + " m/e = " + me);
            }
        }
        int[] pp = new int[2];
        for (int child = 0; child < this.ngenes; ++child) {
            System.out.println("For gene " + child);
            best2[child] = -1.0;
            for (int p1 = 0; p1 < this.ngenes; ++p1) {
                for (int p2 = 0; p2 < this.ngenes && p1 != p2; ++p2) {
                    pp[0] = p1;
                    pp[1] = p2;
                    double mm = this.re.mutualInformation(child, pp, lag);
                    double mme = mm / entropies[child];
                    if (mme > best2[child] && mme > best1[child]) {
                        best2[child] = mme;
                        parents[child] = new int[2];
                        parents[child][0] = p1;
                        parents[child][1] = p2;
                    }
                    System.out.println("for parents = " + p1 + "," + p2 + " m = " + mm + " m/e = " + mme);
                }
            }
        }
        int[] ppp = new int[3];
        for (int child = 0; child < this.ngenes; ++child) {
            best3[child] = -1.0;
            System.out.println("For gene " + child);
            for (int p1 = 0; p1 < this.ngenes; ++p1) {
                for (int p2 = 0; p2 < this.ngenes && p2 != p1; ++p2) {
                    for (int p3 = 0; p3 < this.ngenes && p3 != p2 && p3 != p1; ++p3) {
                        ppp[0] = p1;
                        ppp[1] = p2;
                        ppp[2] = p3;
                        double mmm = this.re.mutualInformation(child, ppp, lag);
                        double mmme = mmm / entropies[child];
                        if (mmme > best3[child] && mmme > best2[child] && mmme > best1[child]) {
                            best3[child] = mmme;
                            parents[child] = new int[3];
                            parents[child][0] = p1;
                            parents[child][1] = p2;
                            parents[child][2] = p3;
                        }
                        System.out.println("for parents = " + p1 + "," + p2 + "," + p3 + " m = " + mmm + " m/e = " + mmme);
                    }
                }
            }
        }
        for (int gene = 0; gene < this.ngenes; ++gene) {
            System.out.println("Parents of gene " + gene);
            for (int par = 0; par < parents[gene].length; ++par) {
                System.out.print(parents[gene][par] + " ");
            }
            System.out.println();
        }
        int[][] lags = new int[this.ngenes][];
        for (int i = 0; i < this.ngenes; ++i) {
            int k = parents[i].length;
            lags[i] = new int[k];
            for (int j = 0; j < k; ++j) {
                lags[i][j] = 1;
            }
        }
        return new RevealOutputGraph(this.ngenes, parents, lags, this.names, "TestReveal");
    }

    public RevealOutputGraph exhaustiveSearch(int lag1, int lag2) {
        if (lag2 <= lag1 || lag1 <= 0) {
            System.out.println("2nd lag must be greater than 1st which must be pos");
            return null;
        }
        int[] parents1 = new int[this.ngenes];
        int[] lags1 = new int[this.ngenes];
        int[][] parents2 = new int[this.ngenes][];
        int[][] lags2 = new int[this.ngenes][];
        int[][] parents3 = new int[this.ngenes][];
        int[][] lags3 = new int[this.ngenes][];
        int[] nparents = new int[this.ngenes];
        int[][] parents = new int[this.ngenes][];
        int[][] lags = new int[this.ngenes][];
        for (int gchild = 0; gchild < this.ngenes; ++gchild) {
            double bestme = -1000.0;
            int[] parent1 = new int[1];
            for (int gparent = 0; gparent < this.ngenes; ++gparent) {
                parent1[0] = gparent;
                for (int lag = lag1; lag <= lag2; ++lag) {
                    double entropyChild = this.re.entropy(gchild, lag);
                    double mutualInf = this.re.mutualInformation(gchild, parent1, lag);
                    double mOverE = mutualInf / entropyChild;
                    if (!(mOverE > bestme)) continue;
                    bestme = mOverE;
                    parents1[gchild] = gparent;
                    lags1[gchild] = lag;
                    nparents[gchild] = 1;
                }
            }
            int[] parent2 = new int[2];
            parents2[gchild] = new int[2];
            lags2[gchild] = new int[2];
            for (int gparent1 = 0; gparent1 < this.ngenes; ++gparent1) {
                for (int lagp1 = lag1; lagp1 <= lag2; ++lagp1) {
                    for (int gparent2 = 0; gparent2 < this.ngenes && gparent1 != gparent2; ++gparent2) {
                        for (int lagp2 = lag1; lagp2 <= lag2; ++lagp2) {
                            parent2[0] = gparent1;
                            parent2[1] = gparent2;
                            int[] lagsa = new int[]{lagp1, lagp2};
                            int lag = lagp1 > lagp2 ? lagp1 : lagp2;
                            double entropyChild = this.re.entropy(gchild, lag);
                            double mutualInf = this.re.mutualInformation(gchild, parent2, lagsa);
                            double mOverE = mutualInf / entropyChild;
                            if (!(mOverE > bestme)) continue;
                            bestme = mOverE;
                            parents2[gchild][0] = gparent1;
                            parents2[gchild][1] = gparent2;
                            lags2[gchild][0] = lagp1;
                            lags2[gchild][1] = lagp2;
                            nparents[gchild] = 2;
                        }
                    }
                }
            }
            int[] parent3 = new int[3];
            parents3[gchild] = new int[3];
            lags3[gchild] = new int[3];
            for (int gparent1 = 0; gparent1 < this.ngenes; ++gparent1) {
                for (int lagp1 = lag1; lagp1 <= lag2; ++lagp1) {
                    for (int gparent2 = 0; gparent2 < this.ngenes; ++gparent2) {
                        for (int lagp2 = lag1; lagp2 <= lag2; ++lagp2) {
                            for (int gparent3 = 0; gparent3 < this.ngenes; ++gparent3) {
                                for (int lagp3 = lag1; lagp3 <= lag2; ++lagp3) {
                                    parent3[0] = gparent1;
                                    parent3[1] = gparent2;
                                    parent3[2] = gparent3;
                                    int[] lagsa = new int[]{lagp1, lagp2, lagp3};
                                    int lag = lagp1 > lagp2 ? lagp1 : lagp2;
                                    lag = lag > lagp3 ? lag : lagp3;
                                    double entropyChild = this.re.entropy(gchild, lag);
                                    double mutualInf = this.re.mutualInformation(gchild, parent3, lagsa);
                                    double mOverE = mutualInf / entropyChild;
                                    if (!(mOverE > bestme)) continue;
                                    bestme = mOverE;
                                    parents3[gchild][0] = gparent1;
                                    parents3[gchild][1] = gparent2;
                                    parents3[gchild][2] = gparent3;
                                    lags3[gchild][0] = lagp1;
                                    lags3[gchild][1] = lagp2;
                                    lags3[gchild][2] = lagp3;
                                    nparents[gchild] = 3;
                                }
                            }
                        }
                    }
                }
            }
            System.out.println("For gene " + gchild + ":");
            if (nparents[gchild] == 1) {
                parents[gchild] = new int[1];
                lags[gchild] = new int[1];
                System.out.println("best parent, lag = " + parents1[gchild] + " " + lags1[gchild]);
                parents[gchild][0] = parents1[gchild];
                lags[gchild][0] = lags1[gchild];
                continue;
            }
            if (nparents[gchild] == 2) {
                parents[gchild] = new int[2];
                lags[gchild] = new int[2];
                System.out.println("best parents, lags = " + parents2[gchild][0] + " " + parents2[gchild][1] + "  " + lags2[gchild][0] + " " + lags2[gchild][1]);
                parents[gchild][0] = parents2[gchild][0];
                parents[gchild][1] = parents2[gchild][1];
                lags[gchild][0] = lags2[gchild][0];
                lags[gchild][1] = lags2[gchild][1];
                continue;
            }
            if (nparents[gchild] != 3) continue;
            parents[gchild] = new int[3];
            lags[gchild] = new int[3];
            System.out.println("best parents, lags = " + parents3[gchild][0] + " " + parents3[gchild][1] + " " + parents3[gchild][2] + " " + lags3[gchild][0] + " " + lags3[gchild][1] + " " + lags3[gchild][2]);
            parents[gchild][0] = parents3[gchild][0];
            parents[gchild][1] = parents3[gchild][1];
            parents[gchild][2] = parents3[gchild][2];
            lags[gchild][0] = lags3[gchild][0];
            lags[gchild][1] = lags3[gchild][1];
            lags[gchild][2] = lags3[gchild][2];
        }
        return new RevealOutputGraph(this.ngenes, parents, lags, this.names, "TestReveal");
    }
}

