/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbComponent;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbFunction;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbFunctionAnd;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbFunctionOr;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbFunctionSV;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbFunctionSum;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbGeneAnd;
import edu.cmu.tetrad.gene.tetrad.gene.algorithm.urchin.NbGeneOr;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.text.NumberFormat;

public class SimulateNetwork {
    public static void main(String[] argv) {
        int i;
        NbFunction matCBeta = new NbFunction(10.0, 1.0, null, null, "Mat CBeta");
        NbFunction liCl = new NbFunction(10.0, 1.0, null, null, "LiCl");
        NbFunction matOtx = new NbFunction(1.0, 1.0, null, null, "Mat Otx");
        NbFunction TCF = new NbFunction(10.0, 1.0, null, null, "TCF");
        NbComponent[] chiparents = new NbComponent[]{matCBeta};
        int[] chicauses = new int[]{1};
        NbFunctionAnd chi = new NbFunctionAnd(1.0, 1.0, chiparents, chicauses, "Chi");
        NbFunction chiSwitch = new NbFunction(10.0, 1.0, null, null, "ChiSwitch");
        NbComponent[] pcparents = new NbComponent[]{chi, chiSwitch};
        int[] pccauses = new int[]{1, 1};
        NbFunctionOr postChi = new NbFunctionOr(1.0, 1.0, pcparents, pccauses, "Post Chi");
        NbComponent[] nBparents = new NbComponent[]{TCF, postChi};
        int[] nBcauses = new int[]{1, 1};
        NbFunctionAnd nB = new NbFunctionAnd(1.0, 1.0, nBparents, nBcauses, "nB");
        NbComponent[] nBmodparents = new NbComponent[]{nB};
        int[] nBmodcauses = new int[]{1};
        NbFunctionSV nBmod = new NbFunctionSV(10.0, 1.0, nBmodparents, nBmodcauses, "nBmod");
        NbComponent[] wnt8parents = new NbComponent[]{nBmod};
        int[] wnt8causes = new int[]{1};
        NbGeneAnd wnt8 = new NbGeneAnd(1.0, 1.0, wnt8parents, wnt8causes, "Wnt8", 0.1);
        NbComponent[] krlparents = new NbComponent[]{nBmod};
        int[] krlcauses = new int[]{1};
        NbGeneAnd krl = new NbGeneAnd(100.0, 1.0, krlparents, krlcauses, "Krl", 0.1);
        NbComponent[] soxb1parents = new NbComponent[]{krl};
        int[] soxb1causes = new int[]{-1};
        NbGeneAnd soxB1 = new NbGeneAnd(1.0, 1.0, soxb1parents, soxb1causes, "SoxB1", 0.1);
        NbComponent[] matotxmodparents = new NbComponent[]{matOtx};
        int[] matotxmodcauses = new int[]{1};
        NbFunctionSV matOtxMod = new NbFunctionSV(10.0, 1.0, matotxmodparents, matotxmodcauses, "MatOtxMod");
        NbComponent[] kroxparents = new NbComponent[]{nBmod};
        int[] kroxcauses = new int[]{1};
        NbGeneOr krox = new NbGeneOr(100.0, 1.0, kroxparents, kroxcauses, "Krox", 0.1);
        krox.addParent(krox, 1);
        wnt8.addParent(krox, 1);
        NbComponent[] otxparents = new NbComponent[]{krox};
        int[] otxcauses = new int[]{1};
        NbGeneOr otx = new NbGeneOr(100.0, 1.0, otxparents, otxcauses, "Otx", 0.1);
        NbComponent[] otxsumparents = new NbComponent[]{matOtxMod, otx};
        int[] otxsumcauses = new int[]{1, 1};
        NbFunctionSum otxSum = new NbFunctionSum(1.0, 1.0, otxsumparents, otxsumcauses, "Otx Sum");
        otx.addParent(otxSum, 1);
        krox.addParent(otxSum, 1);
        NbComponent[] eveparents = new NbComponent[]{krox, nBmod};
        int[] evecauses = new int[]{1, 1};
        NbGeneAnd eve = new NbGeneAnd(100.0, 1.0, eveparents, evecauses, "Eve", 0.1);
        NbComponent[] gsk3parents = new NbComponent[]{liCl, wnt8};
        int[] gsk3causes = new int[]{-1, -1};
        NbFunctionAnd GSK3 = new NbFunctionAnd(1.0, 1.0, gsk3parents, gsk3causes, "GSK-3");
        NbComponent[] gsk3modparents = new NbComponent[]{GSK3};
        int[] gsk3modcauses = new int[]{1};
        NbFunctionSV GSK3Mod = new NbFunctionSV(1.0, 10.0, gsk3modparents, gsk3modcauses, "GSK3 Mod");
        NbComponent[] soxb1modparents = new NbComponent[]{soxB1};
        int[] soxb1modcauses = new int[]{1};
        NbFunctionSV soxB1Mod = new NbFunctionSV(1.0, 10.0, soxb1modparents, soxb1causes, "SoxB1 Mod");
        NbComponent[] prechiparents = new NbComponent[]{GSK3Mod, soxB1Mod};
        int[] prechicauses = new int[]{-1, -1};
        NbFunctionAnd preChi = new NbFunctionAnd(1.0, 1.0, prechiparents, prechicauses, "Pre Chi");
        chi.addParent(preChi, 1);
        NbComponent[] components = new NbComponent[]{matCBeta, liCl, matOtx, TCF, chi, chiSwitch, postChi, nB, nBmod, wnt8, krl, soxB1, matOtxMod, otxSum, krox, otx, eve, GSK3, GSK3Mod, soxB1Mod, preChi};
        matCBeta.setValue(1.0);
        liCl.setValue(0.0);
        matOtx.setValue(1.0);
        TCF.setValue(1.0);
        chi.setValue(0.0);
        chiSwitch.setValue(1.0);
        postChi.setValue(0.0);
        nB.setValue(0.0);
        nBmod.setValue(0.0);
        wnt8.setValue(0.0);
        krl.setValue(0.0);
        soxB1.setValue(0.0);
        matOtxMod.setValue(0.0);
        otxSum.setValue(0.0);
        krox.setValue(0.0);
        otx.setValue(0.0);
        eve.setValue(0.0);
        GSK3.setValue(0.0);
        GSK3Mod.setValue(0.0);
        soxB1Mod.setValue(0.0);
        preChi.setValue(0.0);
        double[][] data = new double[21][6];
        for (int i2 = 0; i2 < components.length; ++i2) {
            data[i2][0] = components[i2].getValue();
            System.out.print(components[i2].getName() + "\t");
        }
        System.out.println();
        for (int hour = 1; hour < 6; ++hour) {
            chi.update();
            postChi.update();
            nB.update();
            nBmod.update();
            wnt8.update();
            krl.update();
            soxB1.update();
            krox.update();
            matOtxMod.update();
            otx.update();
            otxSum.update();
            eve.update();
            GSK3.update();
            GSK3Mod.update();
            soxB1Mod.update();
            preChi.update();
            for (i = 0; i < components.length; ++i) {
                data[i][hour] = components[i].getValue();
            }
        }
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        for (i = 0; i < components.length; ++i) {
            System.out.print(components[i].getName() + "\t");
            for (int hour = 0; hour < 5; ++hour) {
                String dat = nf.format(data[i][hour]);
                System.out.print(dat + "\t");
            }
            System.out.println();
        }
    }
}

