/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.util;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.util.BasicMatrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public abstract class BasicLTMatrix
extends BasicMatrix {
    public BasicLTMatrix(String mname, int nrows) {
        super(mname, nrows);
    }

    public BasicLTMatrix(String fname) throws IOException {
        BufferedReader in;
        block7: {
            File f = new File(fname);
            in = new BufferedReader(new FileReader(f));
            StreamTokenizer strmTok = new StreamTokenizer(in);
            strmTok.slashStarComments(true);
            strmTok.slashSlashComments(true);
            strmTok.parseNumbers();
            strmTok.wordChars(95, 95);
            int nt = strmTok.nextToken();
            if (strmTok.sval == null || !strmTok.sval.toUpperCase().contains("LTMATRIX")) {
                throw new IllegalArgumentException("First token does not contain 'LTMATRIX': " + strmTok.sval);
            }
            nt = strmTok.nextToken();
            this.name = strmTok.sval;
            nt = strmTok.nextToken();
            if (nt != -2) {
                throw new IllegalArgumentException("Error parsing # of rows: " + strmTok.sval);
            }
            this.n = (int)strmTok.nval;
            if (this.n <= 0) {
                throw new IllegalArgumentException("Invalid # nodes " + this.n);
            }
            this.initMatrixStorage();
            int row = 0;
            int col = 0;
            while (true) {
                try {
                    nt = strmTok.nextToken();
                }
                catch (IOException e) {
                    break block7;
                }
                if (nt == -1) break block7;
                if (nt != -2) break;
                this.setDoubleValue(row, col, strmTok.nval);
                if (col < row) {
                    ++col;
                    continue;
                }
                col = 0;
                ++row;
            }
            throw new IllegalArgumentException("Error parsing element (" + row + "," + col + "): " + strmTok.sval);
        }
        in.close();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getName() + " " + this.name + "\n" + this.n + " // <- Total # rows\n");
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c <= r; ++c) {
                s.append(this.getDoubleValue(r, c)).append(" ");
            }
            s.append("\n");
        }
        return s.toString();
    }
}

