/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public abstract class BasicMatrix {
    protected String name;
    protected int n;
    public static final short MAX_SHORT = Short.MAX_VALUE;
    public static final short MIN_SHORT = Short.MIN_VALUE;
    public static final int MAX_INT = Integer.MAX_VALUE;
    public static final int MIN_INT = Integer.MIN_VALUE;
    public static final float MAX_FLOAT = Float.MAX_VALUE;
    public static final float MIN_FLOAT = -3.4028235E38f;

    protected BasicMatrix() {
    }

    public BasicMatrix(String mname, int nrows) {
        this.name = mname;
        if (nrows <= 0) {
            throw new IllegalArgumentException("Invalid # nodes " + nrows);
        }
        this.n = nrows;
        this.initMatrixStorage();
    }

    public BasicMatrix(String fname) throws IOException {
        BufferedReader in;
        block6: {
            File f = new File(fname);
            in = new BufferedReader(new FileReader(f));
            StreamTokenizer strmTok = new StreamTokenizer(in);
            strmTok.slashStarComments(true);
            strmTok.slashSlashComments(true);
            strmTok.parseNumbers();
            strmTok.wordChars(95, 95);
            int nt = strmTok.nextToken();
            if (strmTok.sval == null || !strmTok.sval.toUpperCase().contains("MATRIX")) {
                throw new IllegalArgumentException("First token does not contain 'MATRIX': " + strmTok.sval);
            }
            nt = strmTok.nextToken();
            this.name = strmTok.sval;
            nt = strmTok.nextToken();
            if (nt != -2) {
                throw new IllegalArgumentException("Error parsing # of rows: " + strmTok.sval);
            }
            int vnrows = (int)strmTok.nval;
            if (vnrows <= 0) {
                throw new IllegalArgumentException("Invalid # rows " + vnrows);
            }
            this.n = vnrows;
            this.initMatrixStorage();
            int row = 0;
            int col = 0;
            boolean val = false;
            while (true) {
                try {
                    nt = strmTok.nextToken();
                }
                catch (IOException e) {
                    break block6;
                }
                if (nt == -1) break block6;
                if (nt != -2) break;
                this.setDoubleValue(row, col, strmTok.nval);
                if (++col != vnrows) continue;
                col = 0;
                ++row;
            }
            throw new IllegalArgumentException("Error parsing element [" + row + "," + col + "]: " + strmTok.sval);
        }
        in.close();
    }

    public int getSize() {
        return this.n;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getName() + " " + this.name + "\n" + this.n + " // <- Total # rows\n");
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c < this.n; ++c) {
                s.append(this.getDoubleValue(r, c)).append(" ");
            }
            s.append("\n");
        }
        return s.toString();
    }

    protected void badIndexXcp(int r, int c) {
        throw new IllegalArgumentException("Bad index (" + r + "," + c + ") for matrix of size " + this.n);
    }

    protected abstract void initMatrixStorage();

    public abstract double getDoubleValue(int var1, int var2);

    public abstract void setDoubleValue(int var1, int var2, double var3);

    public abstract void setAllValuesToZero();
}

