/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.util;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.util.BasicLTMatrix;
import java.io.IOException;

public class LTMatrix
extends BasicLTMatrix {
    protected short[] A;

    public LTMatrix(String mname, int nrows) {
        super(mname, nrows);
    }

    public LTMatrix(String fname) throws IOException {
        super(fname);
    }

    @Override
    protected void initMatrixStorage() {
        this.A = new short[this.n * (this.n + 1) / 2];
    }

    @Override
    public void setDoubleValue(int r, int c, double x) {
        if (x < -32768.0 || x > 32767.0) {
            throw new IllegalArgumentException("Double " + x + " cannot be stored as a short");
        }
        this.setValue(r, c, (short)x);
    }

    public void setValue(int r, int c, int x) {
        if (x < Short.MIN_VALUE || x > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Double " + x + " cannot be stored as a short");
        }
        this.setValue(r, c, (short)x);
    }

    public void setValue(int r, int c, short x) {
        if (r < c) {
            this.upperTriangXcp(r, c);
        }
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        this.A[r * (r + 1) / 2 + c] = x;
    }

    @Override
    public double getDoubleValue(int r, int c) {
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        return r >= c ? this.A[r * (r + 1) / 2 + c] : (short)0;
    }

    public short getValue(int r, int c) {
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        return r >= c ? this.A[r * (r + 1) / 2 + c] : (short)0;
    }

    @Override
    public void setAllValuesToZero() {
        for (int i = 0; i < this.A.length; ++i) {
            this.A[i] = 0;
        }
    }

    @Override
    public String toString() {
        String s = this.getClass().getName() + " " + this.name + "\n" + this.n + " // <- Total # rows\n";
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c <= r; ++c) {
                s = s + this.getValue(r, c) + " ";
            }
            s = s + "\n";
        }
        return s;
    }

    private void upperTriangXcp(int r, int c) {
        throw new IllegalArgumentException("Trying to set a value in (" + r + "," + c + ") -> Upper Triangular region ");
    }
}

