/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.util;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.util.BasicMatrix;
import java.io.IOException;

public class Matrix
extends BasicMatrix {
    protected short[][] A;

    public Matrix(String mname, int nrows) {
        super(mname, nrows);
    }

    public Matrix(String fname) throws IOException {
        super(fname);
    }

    @Override
    protected void initMatrixStorage() {
        this.A = new short[this.n][this.n];
    }

    @Override
    public void setDoubleValue(int r, int c, double x) {
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        if (x < -32768.0 || x > 32767.0) {
            throw new IllegalArgumentException("Integer " + x + " cannot be stored as a short");
        }
        this.A[r][c] = (short)x;
    }

    @Override
    public double getDoubleValue(int r, int c) {
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        return this.A[r][c];
    }

    public void setValue(int r, int c, short x) {
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        this.A[r][c] = x;
    }

    public void setValue(int r, int c, int x) {
        if (x < Short.MIN_VALUE || x > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Integer " + x + " cannot be stored as a short");
        }
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        this.A[r][c] = (short)x;
    }

    public short getValue(int r, int c) {
        if (r >= this.n || c >= this.n || r < 0 || c < 0) {
            this.badIndexXcp(r, c);
        }
        return this.A[r][c];
    }

    @Override
    public void setAllValuesToZero() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = 0;
            }
        }
    }

    @Override
    public String toString() {
        String s = this.getClass().getName() + " " + this.name + "\n" + this.n + " // <- Total # rows\n";
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c < this.n; ++c) {
                s = s + this.getValue(r, c) + " ";
            }
            s = s + "\n";
        }
        return s;
    }
}

