/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.tetrad.gene.algorithm.util;

import edu.cmu.tetrad.gene.tetrad.gene.algorithm.util.LTMatrix;
import java.io.IOException;

public class SymMatrix
extends LTMatrix {
    public SymMatrix(String mname, int nrows) {
        super(mname, nrows);
    }

    public SymMatrix(String fname) throws IOException {
        super(fname);
    }

    @Override
    public void setValue(int row, int col, int x) {
        if (row >= col) {
            super.setValue(row, col, x);
        } else {
            super.setValue(col, row, x);
        }
    }

    @Override
    public void setValue(int row, int col, short x) {
        if (row >= col) {
            super.setValue(row, col, x);
        } else {
            super.setValue(col, row, x);
        }
    }

    @Override
    public short getValue(int row, int col) {
        return row >= col ? super.getValue(row, col) : super.getValue(col, row);
    }

    @Override
    public String toString() {
        String s = this.getClass().getName() + " " + this.name + "\n" + this.n + " // <- Total # rows\n";
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c < this.n; ++c) {
                s = s + this.getValue(r, c) + " ";
            }
            s = s + "\n";
        }
        return s;
    }
}

